
import React, { useEffect, useState } from "react";
import * as d3 from "d3";
export default function About() {

    const [ticks,setTicks] = useState<{ value: Date; xOffset: number; }[]>([])

    useEffect(() => {
        const items = [{ date: "2012-01-01", amount: 4.5 }, { date: "2012-02-01", amount: 4.3 }, { date: "2012-03-01", amount: 4.4 }]
        const xScale = d3.scaleTime()
            .domain(items.map(v => {let d = new Date(v.date);return d;}))
            .range([10, 290])
        setTicks(xScale.ticks()
            .map(value => ({
                value,
                xOffset: xScale(value)
            })))
    },[])

    
    return (
        <div>
            <svg id="graph">
                <path
                    d="M 9.5 0.5 H 290.5"
                    stroke="currentColor"
                />
                {ticks.map(({ value, xOffset }) => (
                    <g
                        key={value.getDate()}
                        transform={`translate(${xOffset}, 0)`}
                    >
                        <line
                            y2="6"
                            stroke="currentColor"
                        />
                        <text
                            key={value.getDate()}
                            style={{
                                fontSize: "10px",
                                textAnchor: "middle",
                                transform: "translateY(20px)"
                            }}>
                            {value.getDate()}
                        </text>
                    </g>
                ))}
            </svg>
        </div>
    )
}  