import * as d3 from "d3";
import React from "react";
import {Tooltip} from "react-tooltip";
import {randomKey} from "../common/randomKey";

export function DonutChartLegend({data, radius, transform}:{data: Arc[], radius: number, transform: string}){
    //Génère l'arc pour positionner la première position de la polyline de la légende
    const outerArc = d3.arc().innerRadius(radius * 0.8).outerRadius(radius * 0.8);

    //Génère l'arc permettant de positionner la légende autour du graphique
    const labelArc = d3.arc().innerRadius(radius * 0.9).outerRadius(radius * 0.9)

    //Génère les positions des lignes joignant un arc à son label
    const labelLine = (d: d3.DefaultArcObject) => {
        let posA = outerArc.centroid(d)
        // @ts-ignore
        let posB = labelArc.centroid(d)
        // @ts-ignore
        let posC = labelArc.centroid(d)
        let midangle = d.startAngle + (d.endAngle - d.startAngle) / 2 // we need the angle to see if the X position will be at the extreme right or extreme left
        posC[0] = radius * 0.95 * (midangle < Math.PI ? 1 : -1); // multiply by 1 or -1 to put it on the right or on the left
        return [posA, posB, posC]
    }

    //Génère la position d'un label
    const labelTransform = (d: d3.DefaultArcObject) => {
        let pos = labelArc.centroid(d)
        let midangle = d.startAngle + (d.endAngle - d.startAngle) / 2
        pos[0] = radius * 0.99 * (midangle < Math.PI ? 1 : -1)
        return pos
    }

    //Génère l'ancre du label
    const labelAnchor = (d: d3.DefaultArcObject) => {
        let midangle = d.startAngle + (d.endAngle - d.startAngle) / 2
        return (midangle < Math.PI ? 'start' : 'end')
    }

    return (
        <g>
            {data.map((item) => (
                <g
                    key={randomKey()}
                    transform={transform}
                >
                    {/*Label de l'item*/}
                    <g>
                        <text
                            transform={`translate(${labelTransform(item.angle)})`}
                            textAnchor={labelAnchor(item.angle)}
                        >{item.name}</text>
                    </g>
                    {/*Ligne liant un arc à son label*/}
                    <g>
                        <polyline
                            stroke="black"
                            fill="none"
                            strokeWidth="1"
                            points={labelLine(item.angle).toString()}
                        />
                    </g>
                </g>
            ))}
        </g>
    )
}

/**
 * Fonction dessinant les tooltips pour chaque item
 * @param param0
 * @returns
 */
export function TooltipDivs({data}: {data:{ date: Date }[]}){
    return (
        <div>
            {data.map(({ date}) => (
                <Tooltip html={"true"} key={randomKey()} anchorId={"data:"+date.toISOString()}/>
            ))}
        </div>
    )
}