import fetch from 'node-fetch';

const cache = new Map<string, unknown>();

async function getAmounts(start:Date, end:Date, groupBy: string){
    let isoStart = start.toISOString().substring(0, 10);
    let isoEnd = end.toISOString().substring(0, 10);
    return graphQl<{ amounts: Amount[] }>(
`{
    amounts(groupby: "${groupBy}", dateStart: "${isoStart}", dateEnd: "${isoEnd}") {
        date
        value
    }
}`).then(({ amounts }) => amounts);
}

async function getRegions(year = 2021){
    return graphQl<{ regions: Region[] }>(
`{
  regions(year: ${year}) {
    region
    percentage
  }
}`).then(({ regions }) => regions);
}

async function getSeries() {
    return graphQl<{ series: Series[] }>(
`{
  series {
    date
    value
  }
}`).then(({ series }) => series);
}

async function graphQl<T>(query: string) {
    return getFromCache<T>(query) || fetch('https://localhost/graphql', {
        method: 'POST',
        body: JSON.stringify({ query }),
        headers: {
            accept: 'application/json',
            'content-type': 'application/json',
        }
    }).then(response => response.json())
        .then<T>(({ data }: GraphQLResponse<T>) => {
            cache.set(query, data);
            return data;
        });
}

function getFromCache<T>(query: string) {
    return cache.get(query) as T | undefined;
}

export const ApiService = {
    getAmounts,
    getRegions,
    getSeries
}