import {render, screen, cleanup} from '@testing-library/react'
import { MemoryRouterProvider } from 'next-router-mock/MemoryRouterProvider';
import '@testing-library/jest-dom'
import MainPage from "../components/MainPage";
import Index from "../pages";

describe('Tests sur la page principale', () => {
    beforeEach(() => {
        render(<MainPage content={<Index/>}/>, {wrapper: MemoryRouterProvider})
    })
    afterEach(() => {
        cleanup();
    })
    test('Page de base', () => {
        const p = screen.getByText("Sélectionnez une visualisation dans la liste.")
        expect(p).toBeInTheDocument()

        const a = screen.getByRole("link", {name: /Prix de vente moyen du m²/i});
        expect(a).toBeInTheDocument();
    })
})