<?php

namespace App\Tests\Api;

use ApiPlatform\Symfony\Bundle\Test\ApiTestCase;
use Doctrine\Persistence\ObjectManager;
use App\Repository\SaleRepository;

class SaleTest extends ApiTestCase
{
    public function testGetSeries(): void
    {
        static::createClient()->request('GET', '/series');

        $this->assertResponseHeaderSame('content-type', 'application/ld+json; charset=utf-8');
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            '@context' => '/contexts/Series',
            '@id' => '/series',
            '@type' => 'hydra:Collection',
            'hydra:totalItems' => 10
        ]);
    }

    public function testGetRegions(): void
    {
        static::createClient()->request('GET', '/regions/2018');

        $this->assertResponseHeaderSame('content-type', 'application/ld+json; charset=utf-8');
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            '@context' => '/contexts/Region',
            '@id' => '/regions/2018',
            '@type' => 'hydra:Collection',
            'hydra:totalItems' => 4,
            'hydra:member' => array(0=>array('percentage' => '25.0000000000000000'))
        ]);
    }

    public function testGetAmounts(): void
    {
        static::createClient()->request('GET', '/amounts/groupby=year&dateStart=2018-01-01&dateEnd=2019-01-01');

        $this->assertResponseHeaderSame('content-type', 'application/ld+json; charset=utf-8');
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            '@context' => '/contexts/Amount',
            '@id' => '/amounts/groupby=year%26dateStart=2018-01-01%26dateEnd=2019-01-01',
            '@type' => 'hydra:Collection',
            'hydra:member' => array(0=>array('value' => 4))
        ]);
    }
}
