<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Metadata\GraphQl\QueryCollection;
use App\Resolver\RegionResolver;
use App\State\RegionProvider;

#[ApiResource(operations: [
	new GetCollection(
		uriTemplate: '/regions/{year}', 
		requirements: ['year' => '\d+'],
		defaults: ['year' => 2021]
	)
], graphQlOperations: [
	new QueryCollection(
        resolver: RegionResolver::class,
        read: false,
		args: ['year' => ['type' => 'Int']]
    )
], provider: RegionProvider::class, paginationEnabled: false)]
class Region {
	public string $region;

	public float $percentage;
}