<?php
namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\FixtureInterface;
use Doctrine\Persistence\ObjectManager;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use App\Entity\Sale;

abstract class AbstractSaleFixture extends Fixture implements ContainerAwareInterface, FixtureInterface
{
	const ID_VALUE = 10;
    const ID_DEPARTEMENT = 18;
    const ID_SURFACE = 42;   // Surface terrain
    const ID_DATE = 8;
    /** vente, échange, etc. Sert comme filtre */
    const ID_NATURE = 9;
    /** maison, appartement, etc. Sert comme filtre */
    const ID_TYPE = 36;

    protected $regions = [];

    protected $container;

    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    public function load(ObjectManager $manager)
    {
        $kernel = $this->container->get('kernel');
        if (in_array($kernel->getEnvironment(), $this->getEnvironments())) {
			$fregions = fopen('data/regions.txt', "r");
			while(!feof($fregions)) {
				$tline = explode("\t", fgets($fregions));
				for ($i=0; $i < sizeof($tline); $i++) {
					if(sizeof($tline) > 2 && $tline[2])
						$this->regions[$tline[0]] = substr($tline[2], 0, strlen($tline[2])-1);
				}
			}
			fclose($fregions);
            $this->doLoad($manager);
        }
    }

    abstract protected function doLoad(ObjectManager $manager);

    abstract protected function getEnvironments();

	protected function manageSale($data): Sale
    {
        $sale = new Sale();
        $sale->type = $data[self::ID_TYPE];
        $sale->value = (int) $data[self::ID_VALUE];
        $sale->code_departement = (int) $data[self::ID_DEPARTEMENT];
        $sale->region = $this->regions[$data[self::ID_DEPARTEMENT]];
        $sale->surface = (int) $data[self::ID_SURFACE];
        $sale->date = \DateTimeImmutable::createFromFormat('!d/m/Y', $data[self::ID_DATE]);
        return $sale;
    }
}
