require('dotenv').config();
const crypto = require("crypto");

const id = crypto.randomBytes(4).toString('hex')
const connect = "Server:" + id + ":CONNECT";

let WSocket = require('ws');

let wss = new WSocket('ws://localhost:41848');

wss.on('open', function() {
    wss.send(connect);
});

wss.on('message', function incoming(message) {
    console.log(`received: ${message}`);
});

setInterval(broadcastNew, 1000);

function broadcastNew() {
    var message = "Server:" + id + ":HIT";
    wss.send(message);
    console.log("Sent " + message + " to the wire...");
}