require('dotenv').config();
const express = require('express')
const bodyParser = require('body-parser')
const cors = require('cors')
const { startCommunication, sendMessage, sendMessageAll, addMessageListener, addKeys, keys } = require('./src/utils/communication')
const {startWebSocket} = require("./src/utils/websocketManager");

const app = express()
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
app.use(bodyParser.raw());

const corsOptions = {
    origin: function (origin, callback) {
        callback(null, true)
    },
    credentials: true,
    enablePreflight: true
}
app.use(cors(corsOptions))

const mainRoute = require('./src/routes/main');
const partyRoute = require('./src/routes/party');


app.use('/', mainRoute);
app.use('/party', partyRoute);


const serv = app.listen(process.env.PORT, () => {
    console.log('listening on ' + process.env.PORT)
    console.log('Server live at http://localhost:' + process.env.PORT)
});

startCommunication();
startWebSocket(serv);
console.log(JSON.stringify([{ key: 'fed3dbe5', count: 1 }, { key: 'fed3dbe5', count: 1 }]));
