import { Component } from 'react' 
import { Nombre } from './Nombre'
import style from './Compteur.module.scss'

export class Compteur extends Component {
  constructor(props) {
    super(props)
    
    this.state = {
      count: 43
    }
  }

  componentDidMount() {
    // for demonstration purposes
    this.setState({count: this.props.score})
  }
  
  _getCount() {
    const counts = this.state.count.toString().split('')
    
    return counts.map(_count => {
      if (_count === '-') {
        return <span className={style.vote__column}>-</span>
      } else {
        return <Nombre current={parseFloat(_count)} />
      }
    })
  }

  render() {
    const { count } = this.state
    
    return(
      <div className={style.vote}>
        <p className={style.vote__column}>{this.props.teamName}</p>
        <button className={style.button_64} onClick={() => this.setState({count: count + 1})}> +1 </button>
        <div className={style.vote__columns}>
          {this._getCount()}
        </div>
        <button className={style.button_64} onClick={() => this.setState({count: count - 1})}> -1 </button>
      </div>
    )
  }
}

