import React, { Component } from "react";


export class Setup extends Component {
    constructor(props) {
        super(props);

        this.state = {
            max: 20,
            time: 10000,

            multijoueurs: false,
            teamAuto: true,
            teamA: "Team A", 
            teamB: "Team B"
        };

        this.handleChange = this.handleChange.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleChange(event) {
        const target = event.target;
        const value = target.type === 'checkbox' ? target.checked : target.value;
        const name = target.name;

        this.setState({
            [name]: value
        });
    }

    handleSubmit(event) {
        alert('Your favorite flavor is: ' + this.state.max);
    }
    

    render() {

        return (
            <div className="p-5 my-5 bg-light border-bottom">
                <h3 className="mb-3">Nouvelle Partie</h3>
                <form className="row g-3" action="/setupPlayers" onSubmit={this.handleSubmit}>
                    <h5 className="mb-3">Condition de fin de match</h5>

                    <div className="col">
                        <label htmlFor="time" className="form-label">Durée du match</label>
                        <div className="input-group">
                            <input name="time" type="number" className="form-control" id="time" value={this.state.time} onChange={this.handleChange} required/>
                            <span className="input-group-text">minutes</span>
                        </div>
                    </div>
                    <div className="col">
                        <label htmlFor="max" className="form-label">Nombres de morts maximum</label>
                        <div className="input-group">
                            <input name="max" type="number" className="form-control" id="max" value={this.state.max} onChange={this.handleChange} required/>
                            <span className="input-group-text">morts</span>
                        </div>
                    </div>

                    <hr className="my-4"></hr>

                    <h5 className="mb-3">Parametre d'équipe</h5>

                    <div className="col-12">
                        <div className="form-check form-switch">
                            <input name="multijoueurs" className="form-check-input" type="checkbox" id="multijoueurs" defaultChecked={this.state.multijoueurs} onChange={this.handleChange}/>
                            <label className="form-check-label" htmlFor="multijoueurs">
                                Activer le mode équipe
                            </label>
                        </div>
                    </div>

                    <div className="col-12">
                        <div className="form-check form-switch">
                            <input name="teamAuto" className="form-check-input" type="checkbox" id="teamAuto" defaultChecked={this.state.teamAuto} onChange={this.handleChange} disabled={!this.state.multijoueurs} required/>
                            <label className="form-check-label" htmlFor="teamAuto">
                                Choix des equipes automatique
                            </label>
                        </div>
                    </div>

                    <div className="col">
                        <label htmlFor="teamA" className="form-label">City</label>
                        <input name="teamA" type="text" className="form-control" id="teamA" value={this.state.teamA} onChange={this.handleChange} disabled={!this.state.multijoueurs} required/>
                    </div>
                    <div className="col">
                        <label htmlFor="teamB" className="form-label">City</label>
                        <input name="teamB" type="text" className="form-control" id="teamB" value={this.state.teamB} onChange={this.handleChange} disabled={!this.state.multijoueurs} required/>
                    </div>
                
                    <hr className="my-4"></hr>

                    <div className="col-12">
                        <input className="btn btn-primary" type="submit" />
                    </div>
                </form>
            </div>
        )
    }
}