const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const PlayerSchema = new Schema(
    {
        key: String,
        count: { type: Number, default: 0 },
        name: String,
        team: { type: Number | Boolean, default: false }
    }
);

const PlayerModel = mongoose.model('Player', PlayerSchema);

const WinConditionSchema = new Schema(
    {
        max : Number,
        time : Number
    }
);

const WinConditionModel = mongoose.model('WinCondition', WinConditionSchema);

const PartySchema = new Schema(
    {
        start: { type: Number, default: 0 },
        finish: { type: Number, default: 0 },
        playTime: { type: Number, default: 0 },
        players: { type: [PlayerSchema], default: [] },
        winCondition: { type: WinConditionSchema, default: {} }
    }
);

const PartyModel = mongoose.model('Party', PartySchema);


module.exports = { mongoose, PlayerModel, PartyModel, WinConditionModel }

