require('dotenv').config();
const crypto = require("crypto");
const dgram = require('dgram');

const client = dgram.createSocket('udp4');
const id = crypto.randomBytes(4).toString('hex')
const connect = "Server:" + id + ":CONNECT";

client.send(connect, 0, connect.length, process.env.PORT_UDP, process.env.UDP_ADDR);
console.log("client connection : " + connect);

const m = "Server:" + id + ":PONG";
client.send(m, 0, m.length, process.env.PORT_UDP, process.env.UDP_ADDR);
console.log("client ping : " + m);


setInterval(broadcastNew, 1000);

function broadcastNew() {
    var message = "Server:" + id + ":HIT";
    client.send(message, 0, message.length, process.env.PORT_UDP, process.env.UDP_ADDR);
    console.log("Sent " + message + " to the wire...");
}