import Head from 'next/head'
import { Timer } from '../components/CountDown/Timer'
import { Footer } from '../components/Footer/Footer'
import { Navbar } from '../components/Navbar/Navbar'
import { Compteur } from '../components/Score/Compteur'
import styles from '../styles/Home.module.css'

export default function Home() {
  const teamA = "Rouge";
  const scoreA = 0;

  const teamB = "Bleu";
  const scoreB = 0;

  const time = 60;

  return (
    <div>
      <Head>
        <title>Palu-IoT - Laser Game</title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/favicon.ico" />
      </Head>

      <Navbar />
      <main className={styles.main}>
        <div className="container bg-dark p-5 text-white bg-opacity-25 border border-5 border-white">
          <div className="row">
            <div className="col-sm py-2 d-flex align-items-center justify-content-center">
              <Timer timeLeft={time} />
            </div>
          </div>
          <div className="row">
            <div className="col-sm py-2 d-flex align-items-center justify-content-center">
              <Compteur score={scoreA} teamName={teamA} />
            </div>
            <div class="col-sm py-2 d-flex align-items-center justify-content-center">
              <Compteur score={scoreB} teamName={teamB} />
            </div>
          </div>
          <div className="row">
            <div className="col-sm py-2 d-flex align-items-center justify-content-center">
              <Compteur score={scoreA} teamName={teamA} />
            </div>
            <div className="col-sm py-2 d-flex align-items-center justify-content-center">
              <Compteur score={scoreB} teamName={teamB} />
            </div>
          </div>
        </div>
      </main>
      <Footer />
    </div>
  )
}
