import { Component } from "react";
import Donut from "../D3js/Donut"

export class Element extends Component {
    render() {
        const collapseStr = "collapse_" + String(this.props.index);
        const winner = this.props.game.context[0];

        return (
            <a href="#" className='list-group-item list-group-item-action' data-bs-toggle="collapse" data-bs-target={'#' + collapseStr} aria-current="true" aria-expanded="false" aria-controls={collapseStr}>
                <div className="d-flex gap-3 py-3" >
                    <img src="https://github.com/twbs.png" alt="twbs" width="32" height="32" className="rounded-circle flex-shrink-0" />
                    <div className="d-flex gap-2 w-100 justify-content-between">
                        <div>
                            <h6 className="mb-0">{this.props.game.name}</h6>
                            <p className="mb-0 opacity-75">{winner}</p>
                        </div>
                        <small className="opacity-50 text-nowrap">{this.props.game.date}</small>
                    </div>
                </div>
                <div className="collapse" id={collapseStr}>
                    <div className="card card-body">
                        <div className="row">
                            <div className="col-sm py-2 d-flex align-items-center justify-content-center">
                                <Donut data={this.props.game.context}/>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        )
    }
}