import { Component } from "react";
import Router from 'next/router'

export class Hero extends Component {
    constructor(props) {
        super(props);
        this.handleClick = this.handleClick.bind(this);
    }
    handleClick(event) {
        switch (event.target.name) {
            case "Leaderboard":
                Router.push('/leaderboard')
                break;
            case "NewGame":
                Router.push('/setup')
                break;
            default:
                Router.push('/install')
                break;
        }
    }
    render() {
        return (
            <div className="px-4 pt-5 my-5 bg-light text-center border-bottom">
                <h1 className="display-4 fw-bold">{this.props.title}</h1>
                <div className="col-lg-6 mx-auto">
                    <p className="lead mb-4">{this.props.text}</p>
                    <div className="d-grid gap-2 d-sm-flex justify-content-sm-center mb-5">
                        <button name="NewGame" type="button" className="btn btn-primary btn-lg px-4" onClick={this.handleClick}>Commencer maintenant !</button>
                        <button name="Install" type="button" className="btn btn-outline-secondary btn-lg px-4" onClick={this.handleClick}>Installation</button>
                        <button name="Leaderboard" type="button" className="btn btn-outline-secondary btn-lg px-4" onClick={this.handleClick}>Leaderboard</button>
                    </div>
                </div>
            </div>
        )
    }
}