const dgram = require('dgram');
const server = dgram.createSocket("udp4");

let events = [
    (message, remote) => console.log('MCast Msg: From: ' + remote.address + ':' + remote.port + ' - ' + message)
]

server.on('listening', function () {
    var address = server.address();
    console.log('UDP Client listening on ' + address.address + ":" + address.port);
});

server.on('message', function (message, remote) {
    
    for (e of events) {
        e(message, remote);
    }
});

function startUdp(port = process.env.PORT_UDP, adress = process.env.UDP_ADDR) {
    server.bind(port, function () {
        server.setBroadcast(true);
        server.setMulticastTTL(128);
        server.addMembership(adress);
    });
}

function addMessageListener(messageFunc) {
    events.push(messageFunc)
}

function parseMessage(message) {
    return message + "";
}

module.exports = {startUdp, addMessageListener, parseMessage}

