const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const EventSchema = new Schema(
    {
        id: String,
        date: { type: Date, default: Date.now }
    }
);

const EventModel = mongoose.model('Event', EventSchema);

const PartySchema = new Schema(
    {
        events : {type : [EventSchema], default : []}
    }
);

const PartyModel = mongoose.model('Party', PartySchema);


module.exports = {mongoose, EventModel, PartyModel}

