const express = require('express');
const initiateQuery = require("../utils/query")
const { mongoose, EventModel } = require('../utils/mongo');
var router = express.Router();
const {addMessageListener, parseMessage} = require('../utils/udp')


mongoose
    .connect(process.env.MONGO, {
        useNewUrlParser: true,
        useUnifiedTopology: true,
    })
    .catch((err) => console.log("CONNECT", err));


router.get('/get/', function (req, res, next) {
    (async () => {

        let response = "";
        initQuery = initiateQuery(req.query);
        const users = await EventModel
            .find(req.query)
            .limit(parseInt(initQuery[2]))
            .skip(parseInt(initQuery[2]) * parseInt(initQuery[1]))
            .sort(initQuery[3]);

        response = res.send(users)

        return response;
    })();
});

router.get('/all/', function (req, res, next) {
    (async () => {
        let response = "";
        const users = await EventModel.find();
        response = res.send(users);

        return response;
    })();
});

addMessageListener(async (message, remote) => {
    // ici faire un switch si parsing de message
    id = parseMessage(message)
    const u = await EventModel.create({
        id : id
    });

    console.log(u)
});



module.exports = router;
