require('dotenv').config();
const express = require('express')
const bodyParser = require('body-parser')
const cors = require('cors')
const {startUdp} = require('./src/utils/udp')

const app = express()
app.use(bodyParser.urlencoded({ extended: true }))

const corsOptions = {
    origin: function (origin, callback) {
        callback(null, true)
    },
    credentials: true,
    enablePreflight: true
}
app.use(cors(corsOptions))

const mainRoute = require('./src/routes/main');
const eventRoute = require('./src/routes/event');
const partyRoute = require('./src/routes/party');


app.use('/', mainRoute);
app.use('/event', eventRoute);
app.use('/party', partyRoute);


app.listen(process.env.PORT, () => {
    console.log('listening on ' + process.env.PORT)
    console.log('Server live at http://localhost:' + process.env.PORT)
});

startUdp();
