#include <SPI.h>
#include <ESP8266WiFi.h>
#include <WiFiUdp.h>
#include "arduino_secrets.h"

#define SENSOR_PIN A0
#define TRIGER_PIN D6
#define LASER_PIN D5
#define LED_PIN D4

#define KEY_LENGTH 8
#define TIME_OF_DEATH 5000
#define SEUIL_OF_DEATH 800

IPAddress multicastAddress = IPAddress(230, 185, 192, 108);
//IPAddress multicastAddress = IPAddress(229, 97, 225, 144);
unsigned int localPort = 41848;
//unsigned int localPort = 2390;
char ssid[] = SECRET_SSID;
char pass[] = SECRET_PASS;

WiFiUDP Udp;

String localId;
String serverId = String("Server");
char separateur[] = ":";
char packetBuffer[256]; //buffer to hold incoming packet

bool isAlive = true;
int tmpOfDeath = 0;

void setup()
{
	pinMode(SENSOR_PIN, INPUT);
	pinMode(TRIGER_PIN, INPUT);
	pinMode(LASER_PIN, OUTPUT);
	pinMode(LED_PIN, OUTPUT);

	Serial.begin(115200);
	delay(5000);

	/* initialize random seed: */
	srand(time(0));
	localId = hexaGenerator(KEY_LENGTH);
	Serial.print("ID : ");
	Serial.println(localId);

	WiFi.mode(WIFI_STA);
	Serial.print("Attempting to connect to SSID: ");
	Serial.println(ssid);
	Serial.print("Connecting");
	// Connect to WPA/WPA2 network. Change this line if using open or WEP network:
	WiFi.begin(ssid, pass);
	do
	{
		delay(1000);
		Serial.print(".");
	} while (WiFi.status() != WL_CONNECTED);
	Serial.print("Connected! IP address: ");
	Serial.println(WiFi.localIP());
	Serial.printf("UDP server on port %d\n", localPort);
	Udp.beginMulticast(WiFi.localIP(), multicastAddress, localPort);
	Serial.println(multicastAddress);
}

void loop()
{
	if (isAlive)
	{
		shootLaser();
		chestState();
	}
	else
	{
		respawn();
	}

	//Serial.println( analogRead( SENSOR_PIN ) );
	parseData();
}



void setDead(bool state){
	if (state) {
		digitalWrite(LASER_PIN, LOW);
		digitalWrite(LED_PIN, HIGH);
		isAlive = false;
	} else {
		digitalWrite(LED_PIN, LOW);
		tmpOfDeath = 0;
		isAlive = true;
	}
}

void respawn()
{
	if (tmpOfDeath < TIME_OF_DEATH)
	{
		tmpOfDeath++;
		delay(1);
	}
	else
	{
		setDead(false);
	}
}

void chestState()
{
	if (analogRead(SENSOR_PIN) > SEUIL_OF_DEATH)
	{
		sendMsg("HIT");
		setDead(true);
	}
}

void shootLaser()
{
	if (digitalRead(TRIGER_PIN) == HIGH)
	{
		digitalWrite(LASER_PIN, HIGH);
	}
	else
	{
		digitalWrite(LASER_PIN, LOW);
	}
}


void parseData()
{
	int packetSize = Udp.parsePacket();
	if (packetSize)
	{
		int len = Udp.read(packetBuffer, 255);
		if (len > 0)
		{
			packetBuffer[len] = 0;
		}

		printData(packetSize);

		String token = String(strtok(packetBuffer, separateur));
		if (token == localId)
		{
			token = strtok(NULL, separateur);
			if (token == serverId)
			{
				token = strtok(NULL, separateur);
				if (token == "SERVER_TEST")
				{
					sendMsg("TEST_RECEIVED");
				}
				else if (token == "PING")
				{
					sendMsg("PONG");
					setDead(true);
				}
			}
		}

	}
}

void printData(int packetSize)
{
	Serial.print("Received packet of size ");
	Serial.println(packetSize);

	Serial.print("From ");
	IPAddress remoteIp = Udp.remoteIP();
	Serial.print(remoteIp);
	Serial.print(", port ");
	Serial.println(Udp.remotePort());

	Serial.println("Contents : ");
	Serial.println(packetBuffer);
}

void sendMsg(char *msg)
{
	char buf[256];
	String str = serverId;
	str.concat(separateur);
	str.concat(localId);
	str.concat(separateur);
	str.concat(msg);
	str.toCharArray(buf, 256);

	Udp.beginPacket(multicastAddress, localPort);
	Udp.write(buf);
	Udp.endPacket();

	Serial.print("Msg Send : ");
	Serial.println(buf);
}

String hexaGenerator(int length)
{
	int val = rand();
	char hex[length];
	itoa(val, hex, 16);
	String result = String(hex);
	Serial.print("\nEquivalent Hex Byte: ");
	Serial.println(result);
	return result;
}