package com.github.oxal;

import org.graphstream.algorithm.Dijkstra;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.generator.BarabasiAlbertGenerator;
import org.graphstream.algorithm.generator.Generator;
import org.graphstream.algorithm.generator.RandomGenerator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceEdge;

import java.io.*;
import java.util.ArrayList;
import java.util.Collection;

public class Main {

    public static void main(String[] args) {
        String filePath = "src/main/resources/graph.txt";
        Graph g = new DefaultGraph("fichier");
        FileSource fs = new FileSourceEdge();

        fs.addSink(g);

        try {
            fs.readAll(filePath);
        } catch (IOException e) {
            e.printStackTrace();
        }


        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter("degres.txt"));
            int[] dd = Toolkit.degreeDistribution(g);
            for (int k = 0; k < dd.length; k++) {
                if (dd[k] != 0) {

                    String str = String.format("%d\t%f\n", k, (double)dd[k] / g.getNodeCount()).replace(",", ".");
                    writer.write(str);
                }
            }
            writer.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        stat(g);


        Graph barabasiAlbertGenerator = new SingleGraph("BarabasiAlbertGenerator");
        Generator genAlert = new BarabasiAlbertGenerator((int) Toolkit.averageDegree(g));
        genAlert.addSink(barabasiAlbertGenerator);
        genAlert.begin();
        for(int i=0; i<g.getNodeCount(); i++)
            genAlert.nextEvents();
        genAlert.end();

        stat(barabasiAlbertGenerator);



        Graph randomGenerator = new SingleGraph("RandomGenerator");
        Generator gen = new RandomGenerator(Toolkit.averageDegree(g));
        gen.addSink(randomGenerator);
        gen.begin();
        for(int i=0; i<g.getNodeCount(); i++)
            gen.nextEvents();
        gen.end();

        stat(randomGenerator);
    }

    public static void stat(Graph g){
        System.out.println(g.getId());
        //nb de node
        System.out.println("nb node " + g.getNodeCount());

        //nb de edge
        System.out.println("nb edge " + g.getEdgeCount());


        //moyenne de degré
        System.out.println("moy degre " + Toolkit.averageDegree(g));
        System.out.println("moy degre " + (g.getNodeSet()
                .stream()
                .map(n -> n.getDegree()*n.getDegree())
                .reduce(0, (a, b) -> a + b)/g.getNodeCount())
        );

        //coef cluster
        System.out.println("coef cluster " + Toolkit.averageClusteringCoefficient(g));


        //connexe
        System.out.println("connexe " + Toolkit.isConnected(g));

        Collection<Node> list = Toolkit.randomNodeSet(g, 1000);

        Dijkstra dij = new Dijkstra();
        dij.init(g);

        ArrayList<Integer> countLength = new ArrayList<>();

        Node n1 = Toolkit.randomNode(g);
        dij.setSource(n1);
        dij.compute();

        for (Node n2 : list){
            if (n1 != n2){
                Path path = dij.getPath(n2);
                countLength.add(path.getEdgeSet().size());
            }
        }
        System.out.println(countLength.stream().mapToDouble(Integer::doubleValue).average());
        System.out.println();
    }
}
