package com.github.oxal;

import org.graphstream.algorithm.Toolkit;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceEdge;

import java.io.IOException;
import java.util.function.Consumer;

public class Epidemi {

    private Graph g;
    private Node origin;
    private Consumer<Node> infection;
    private Consumer<Node> soin;
    public static final String INFECTED = "infected";

    public Epidemi(Graph g) {
        this.g = g;
    }

    public void init(Node n){
        origin = n;
    }

    public Consumer<Node> getInfection() {
        return infection;
    }

    public void setInfection(Consumer<Node> infection) {
        infection.accept(origin);
        this.infection = infection;
    }

    public Consumer<Node> getSoin() {
        return soin;
    }

    public void setSoin(Consumer<Node> soin) {
        this.soin = soin;
    }

    public void run(int t){
        for (int i = 0; i < t; i++){

            System.out.println(String.format("nombre d'infecter au jour %d : %d", i, g.getNodeSet()
                    .stream()
                    .filter(n -> n.hasAttribute(INFECTED) && n.<Boolean>getAttribute(INFECTED))
                    .count()
                    )
            );
            g.getNodeSet().forEach(n -> {
                n.getEdgeSet()
                        .forEach(e -> getInfection().accept(e.getOpposite(n)));
            });
            g.getNodeSet().forEach(n -> {
                n.getEdgeSet()
                        .forEach(e -> getSoin().accept(e.getOpposite(n)));
            });

        }
    }

    public static void main(String[] args) {
        String filePath = "src/main/resources/graph.txt";
        Graph g = new DefaultGraph("fichier");
        FileSource fs = new FileSourceEdge();

        fs.addSink(g);

        try {
            fs.readAll(filePath);
        } catch (IOException e) {
            e.printStackTrace();
        }

        Epidemi epidemi = new Epidemi(g);
        epidemi.init(Toolkit.randomNode(g));
        epidemi.setInfection(n -> {
            n.setAttribute(INFECTED, true);
        });
        epidemi.setSoin(n -> {
            if (n.hasAttribute(INFECTED)){
                n.setAttribute(INFECTED, false);
            }
        });

        epidemi.run(90);
    }
}
