import Vue from "vue";
import VueRouter from "vue-router";
import Home from "../views/Home.vue";
// import Sensor from "../components/Sensor.vue";

Vue.use(VueRouter);

const routes = [
  {
    path: "/",
    name: "Home",
    component: Home
  },
  {
    path: "/about",
    name: "About",
    // route level code-splitting
    // this generates a separate chunk (about.[hash].js) for this route
    // which is lazy-loaded when the route is visited.
    component: () =>
      import(/* webpackChunkName: "about" */ "../views/About.vue")
  },
  {
    path: "/sensors",
    // route level code-splitting
    // this generates a separate chunk (about.[hash].js) for this route
    // which is lazy-loaded when the route is visited.
    component: () =>
      import(/* webpackChunkName: "sensor" */ "../views/Sensors.vue"),
    children: [
      // {
      //   name: "Sensors",
      //   path: "",
      //   component: { template: "<p>Select a sensor or give a broker url!</p>" }
      // },
      {
        // Sensor will be rendered inside Sensors' <router-view>
        // when /sensors/:name is matched
        path: ":name"
        // component: Sensor
      }
    ]
  }
];

const router = new VueRouter({
  mode: "history",
  base: process.env.BASE_URL,
  routes
});

export default router;
