import mqtt from "mqtt";

let client = null;

const SensorClient = {
  connectedCallback: console.log,
  closedCallback: console.log,
  dataCallback: console.log
};

const onConnect = () => {
  SensorClient.connectedCallback();
  client.subscribe("value/#");
};

const onConnectionClosed = msg => () => {
  console.error(msg);
  SensorClient.closedCallback(msg);
};

const onMessageArrived = (topic, message) => {
  SensorClient.dataCallback({
    topic: topic,
    payload: JSON.parse(message.toString())
  });
};

SensorClient.connect = (url = "ws://localhost:8080") => {
  if (client != null) {
    client.end(true);
  }
  client = mqtt.connect(url);
  client.on("message", onMessageArrived);
  client.on("connect", onConnect);
  client.on("close", onConnectionClosed("MQTT client disconnected."));
  client.on("reconnect", onConnectionClosed("MQTT client reconnecting."));
  client.on("offline", onConnectionClosed("MQTT client went offline."));
  client.on("error", error => SensorClient.closedCallback(error));
  client.on("end", onConnectionClosed("MQTT client ended the connection."));
};

SensorClient.disconnect = () => {
  return new Promise(resolve => {
    if (client != null) {
      client.end(true, () => {
        client = null;
        resolve();
      });
    } else {
      resolve();
    }
  });
};

export default SensorClient;
