import net.arikia.dev.drpc.callbacks.*;
import net.arikia.dev.drpc.DiscordRPC;
import net.arikia.dev.drpc.DiscordRichPresence;
import net.arikia.dev.drpc.DiscordEventHandlers;
import processing.sound.*;


SoundFile menuMusic;
SoundFile rouge;
SoundFile bleu;
SoundFile jaune;
SoundFile vert;
SoundFile perdu;
SoundFile eatserEGG;
IntList indcareclic;
IntList indcarejeux;
int s1carGH;
int s2carGH;
int s1carDH;
int s2carDH;
int s1carGB;
int s2carGB;
int s1carDB;
int s2carDB;
int numberclick;
int numberround;
int ind;
boolean isloosing = false;
boolean gameOverSoundHasBeenPlayedOnce = false;
PFont comic;
int score;
boolean isstilltaken = false;
boolean needToDraw = true;
int colbc = 200;
boolean isDrawingSeq = false;
boolean needtoplayrouge = true;
boolean needtoplaybleu = true;
boolean needtoplayjaune = true;
boolean needtoplayvert = true;
boolean allowedToPlayMusicMenu = true;
boolean gameOvermiliHasbeenDiscovered = false;

SettingsJSON settingsShits;

MainMenu mainMenu;
boolean isInMainMenu = true;
boolean needToPlay = false;
SettingsMenu settings;
SettingsJSON settingsFiles;
boolean needToSwitchToSettings = false;
GameOver gameOver;

DiscordRPC rpc;
DiscordEventHandlers handlers;

void setup() {
  handlers = new DiscordEventHandlers.Builder().setReadyEventHandler((user) -> {
    System.out.println("Welcome " + user.username + "#" + user.discriminator + "!");
  }
  ).build();
  DiscordRPC.discordInitialize("1063935289539694684", handlers, true);
  
  DiscordRichPresence rich = new DiscordRichPresence.Builder("Chargement").setBigImage("icon", "logo").build();
  DiscordRPC.discordUpdatePresence(rich);
  size(800, 800);
  // Icone Fenêtre
  PImage icon = loadImage("data/icon.png");
  surface.setIcon(icon);
  surface.setLocation(displayWidth/2-width/2, displayHeight/2-height/2);   // Pour éviter les problèmes de fenêtre, on remet la fenêtre au centre car """"" on sait jamais """""
  background(0);
  fill(255);
  text("Chargement...", 100, 0);
  settingsShits = new SettingsJSON();
  settingsShits.loadSettings();
  // Initiatlistaion du menu
  mainMenu = new MainMenu();
  //Logos
  mainMenu.logoDarkMode = loadImage("data/logo.png");
  mainMenu.logoLightMode = loadImage("data/logo2.png");
  mainMenu.logoMasterclass = loadImage("data/La symphonie du Simon - Huile sur Toile - 1988 , Pablo Picasso.png");
  // Valeur pour les teintes de gris des bouttons sur le menu
  if (settingsShits.darkMode) {
    mainMenu.fillPlayButton = 38;
    mainMenu.fillMenuButton = 38;
  } else {
    mainMenu.fillMenuButton = 255;
    mainMenu.fillPlayButton = 255;
  }
  // On pré-charge les autres menu
  settings = new SettingsMenu();
  gameOver = new GameOver();
  // On indique le nom des paramètres
  settings.setArray[0] = "darkmode";
  settings.setArray[1] = "chaosmode";
  // Tout les sons, on les charge et on change le son avec amp
  menuMusic = new SoundFile(this, "data/title.mp3");
  menuMusic.amp(0.6);
  rouge = new SoundFile(this, "data/rouge.mp3");
  bleu = new SoundFile(this, "data/bleu.mp3");
  jaune = new SoundFile(this, "data/jaune.mp3");
  vert = new SoundFile(this, "data/vert.mp3");
  perdu = new SoundFile(this, "data/perdu.mp3");
  eatserEGG = new SoundFile(this, "data/ui.mp3");
  eatserEGG.amp(0.8);
  // Les listes pour le jeu
  indcareclic = new IntList();
  indcarejeux = new IntList();
  // Indice allant de 0 à 3. 0 = le bout en haut a gauche, 1= le bout en haut à droite. 2 = le bout en bas à gauche et 3 = le bout en bas à droite
  indcarejeux.append(int(random(0, 4)));
  // Indice des listes pour les  vérifiers (j'ai du utiliser autre chose qu'une bouble for)
  ind = 0;
  // Le comic sans ms pour le texte dans le jeu
  comic = createFont("COMIC.TTF", 10);
  textFont(comic);
  //println(sketchPath());
  DiscordRichPresence rich2 = new DiscordRichPresence.Builder("Dans le menu").setBigImage("icon", "logo").build();
  DiscordRPC.discordUpdatePresence(rich2);
}

void draw() {
  if (isInMainMenu && !needToPlay && !needToSwitchToSettings) {  // Le menu principal
    gameOvermiliHasbeenDiscovered = false;
    //println(menuMusic.isPlaying());
    if (!menuMusic.isPlaying() && allowedToPlayMusicMenu) {
      menuMusic.play();
    }
    mainMenu.draw();
    isloosing = mainMenu.isDead;
    needToPlay = mainMenu.isPlayGame;
    needToSwitchToSettings = mainMenu.isSettings;
    if (needToPlay || needToSwitchToSettings) {
      if (needToPlay) {
        DiscordRichPresence rich = new DiscordRichPresence.Builder("Le Jeu").setBigImage("icon", "logo").build();
        DiscordRPC.discordUpdatePresence(rich);
      }
      if (needToSwitchToSettings) {
        DiscordRichPresence rich = new DiscordRichPresence.Builder("Paramètres").setBigImage("icon", "logo").build();
        DiscordRPC.discordUpdatePresence(rich);
      }
      isInMainMenu = false;
      isloosing = false;
      score = 0;
    }
  } else if (needToSwitchToSettings && !isInMainMenu && !needToPlay) {  //Le menu des params
    if (!menuMusic.isPlaying() && allowedToPlayMusicMenu) {
      menuMusic.play();
    }
    settings.draw();
    isInMainMenu = settings.needToGoInMenu;
    if (isInMainMenu) {
      DiscordRichPresence rich = new DiscordRichPresence.Builder("Dans le menu").setBigImage("icon", "logo").build();
      DiscordRPC.discordUpdatePresence(rich);
      settingsShits.loadSettings();
      needToSwitchToSettings = false;
      isloosing = false;
    }
  } else if (!isloosing && !isInMainMenu && !needToSwitchToSettings && needToPlay) {
    gameOvermiliHasbeenDiscovered = false;
    if (menuMusic.isPlaying()) {
      menuMusic.stop();
    }
    surface.setTitle("LE JEU");
    needToPlay = true;
    isloosing = false;
    background(colbc);
    // On récupère les millisecondes pour chaque bouts
    s2carGH = millis();
    s2carDH = millis();
    s2carGB = millis();
    s2carDB = millis();
    // On réinitialise les variables
    isstilltaken = false;
    needtoplayrouge = true;
    needtoplaybleu = true;
    needtoplayjaune = true;
    needtoplayvert = true;

    // Le desing du jeux
    strokeWeight(0);
    background(colbc);

    strokeWeight(10);
    ellipse(width / 2, height / 2, width - 10, height - 10);
    fill(0, 0, 255);
    arc(width / 2, height / 2, width - 10, height - 10, 0, HALF_PI);
    fill(255, 255, 0);
    arc(width / 2, height / 2, width - 10, height - 10, HALF_PI, PI);
    fill(0, 255, 0);
    arc(width / 2, height / 2, width - 10, height - 10, -PI, -HALF_PI);
    fill(255, 0, 0);
    arc(width / 2, height / 2, width - 10, height - 10, -HALF_PI, 0);
    fill(0, 0, 0, 125);
    ellipse(width / 2, height / 2, width - 10, height - 10);

    fill(0);
    stroke(0);
    line(width / 2, height / 3, width / 2, 5);
    line(width / 2, height - height / 3, width / 2, height - 5);
    line(width / 3, height / 2, 5, height / 2);
    line(width - width / 3, height / 2, width - 5, height / 2);

    /*
     */
    //Avec les millusecondes récupéré, on regarde si on doit toujours dessiner les arcs de cercle
    isDrawingSeq = true;
    if (!isstilltaken) {
      if ((s1carGH + 500 > s2carGH)) {
        needtoplaybleu = false;
        drawArc(3, false);
        isstilltaken = true;
      }
      if ((s1carDH + 500 > s2carDH)) {
        needtoplayjaune = false;
        drawArc(2, false);
        isstilltaken = true;
      }
      if ((s1carDB + 500 > s2carDB)) {
        needtoplayrouge = false;
        drawArc(1, false);
        isstilltaken = true;
      }
      if ((s1carGB + 500 > s2carGB)) {
        needtoplayvert = false;
        drawArc(0, false);
        isstilltaken = true;
      }
    }
    isDrawingSeq = false;

    fill(colbc);

    verify();

    // Le + petit cercle
    stroke(0);
    ellipse(width / 2, height / 2, width / 3, height / 3);
    fill(0);
    comic = createFont("COMIC.TTF", 52);
    textSize(width/12.5);
    textAlign(CENTER);
    text("score: " + str(score), width / 2, height / 2);
  } else {  // C'est le gameover
    if (!(rouge.isPlaying() && vert.isPlaying() && bleu.isPlaying() && jaune.isPlaying())) {  // Si les sons du jeu sont arêté, on joue celui du gameover
      if (!gameOverSoundHasBeenPlayedOnce) {  // On essaye de le jouer qu'une fois, si ça a été jouer une fois, on met le booléen a vrai
        perdu.play();
        gameOverSoundHasBeenPlayedOnce = true;
      }
    }



    if (!gameOvermiliHasbeenDiscovered) { // ON récupere quand le game over est tombé et on remets la fenêtre
      if (settingsShits.chaosMode) {
        surface.setSize(800, 800);
        surface.setLocation(displayWidth/2-width/2, displayHeight/2-height/2);
      }
      gameOver.t1 = millis();
      gameOvermiliHasbeenDiscovered = true;
    }
    gameOver.gameOverScreen(score);
    isInMainMenu = gameOver.goToMenu;
    needToPlay = gameOver.retry;

    if (isInMainMenu) {
      DiscordRichPresence rich = new DiscordRichPresence.Builder("Dans le menu").setBigImage("icon", "logo").build();
      DiscordRPC.discordUpdatePresence(rich);
      isloosing = false;
      needToPlay = false;
      gameOvermiliHasbeenDiscovered = false;
      gameOverSoundHasBeenPlayedOnce = false;
    }
    if (needToPlay) {
      DiscordRichPresence rich = new DiscordRichPresence.Builder("Le Jeu").setBigImage("icon", "logo").build();
      DiscordRPC.discordUpdatePresence(rich);
      isloosing = false;
      gameOvermiliHasbeenDiscovered = false;
      gameOverSoundHasBeenPlayedOnce = false;
    }
  }
}


void mousePressed() {
  if (needToSwitchToSettings) {
    for (int i = 0; i < settings.setArray.length; i++) {
      if (mouseY > ((i+1)*(height/8))-height/32 && mouseY < ((i+1)*height/8) + height/32 && mouseX > width/8 - height/32 && mouseX <  width/8 + height/32) {
        settingsShits.changeSettings(settings.setArray[i]);
      }
    }
  } else {// On récupere juste la couleur où l'utilisateur a cliqué et en fonction de cette couleur, on attribut l'indice (expliqué dans le setup) de l'arc de cercle
    color couleurpoint = get(mouseX, mouseY);
    if (numberclick >= numberround && !isloosing && !needToDraw) {
      boolean canDoTheThings = false;
      switch(couleurpoint) {
      case -16743936:
        indcareclic.append(0);
        drawArc(0, true);
        canDoTheThings = true;
        break;
      case -16711936:
        indcareclic.append(0);
        drawArc(0, true);
        canDoTheThings = true;
        break;
      case -8257536:
        indcareclic.append(1);
        drawArc(1, true);
        canDoTheThings = true;
        break;
      case -65536:
        indcareclic.append(1);
        drawArc(1, true);
        canDoTheThings = true;
        break;
      case -8224256:
        indcareclic.append(2);
        drawArc(2, true);
        canDoTheThings = true;
        break;
      case -256:
        indcareclic.append(2);
        drawArc(2, true);
        canDoTheThings = true;
        break;
      case -16777086:
        indcareclic.append(3);
        drawArc(3, true);
        canDoTheThings = true;
        break;
      case -16776961:
        indcareclic.append(3);
        drawArc(3, true);
        canDoTheThings = true;
        break;
      }

      if (settingsShits.chaosMode && canDoTheThings && !System.getProperty("os.name").contains("Windows")) {  // Repositione fenêtre si le chaos mode est activé et si on a touché la bonne couleur
        surface.setSize(int(random(100, 1000)), int(random(100, 1000)));
        surface.setLocation(int(random(0, displayWidth-width)), int(random(0, displayHeight-height)));
      }
    }
  }
}

void keyPressed() {
  //println("désactivé");
  if (keyCode ==  32) {   // Apuyez sur espace à tout moment ou faites ce que vous voulez ;)
    allowedToPlayMusicMenu = false;
    if (!eatserEGG.isPlaying()) {
      if (menuMusic.isPlaying()) {
        menuMusic.stop();
      }
      eatserEGG.play();
    } else {
      if (menuMusic.isPlaying()) {
        menuMusic.stop();
      }
      eatserEGG.stop();
      eatserEGG.play();
    }
  } else if (keyCode == 8) {
    eatserEGG.stop();
    if (isInMainMenu || needToSwitchToSettings) {
      allowedToPlayMusicMenu = true;  // Pour reprendre la musique du menu
    }
  }
}

void drawArc(int noArc, boolean canPlay) {  //Déssine juste les arc de cercles
  strokeWeight(1);
  switch(noArc) {
  case 0:
    fill(0, 255, 0);
    arc(width / 2, height / 2, width - 10, height - 10, -PI, -HALF_PI);
    if (!isDrawingSeq) {
      s1carGB = millis();
    }

    if (canPlay) {
      vert.play();
    } else {
      if (!vert.isPlaying() && needtoplayvert) {
        vert.play();
      }
    }

    break;
  case 1:
    fill(255, 0, 0);
    arc(width / 2, height / 2, width - 10, height - 10, -HALF_PI, 0);
    if (!isDrawingSeq) {
      s1carDB = millis();
    }

    if (canPlay) {
      rouge.play();
    } else {
      if (!rouge.isPlaying() && needtoplayrouge) {
        rouge.play();
      }
    }
    break;
  case 2:
    fill(255, 255, 0);
    arc(width / 2, height / 2, width - 10, height - 10, HALF_PI, PI);
    if (!isDrawingSeq) {
      s1carDH = millis();
    }

    if (canPlay) {
      jaune.play();
    } else {
      if (!jaune.isPlaying() && needtoplayjaune) {
        jaune.play();
      }
    }
    break;
  case 3:
    fill(0, 0, 255);
    arc(width / 2, height / 2, width - 10, height - 10, 0, HALF_PI);
    if (!isDrawingSeq) {
      s1carGH = millis();
    }

    if (canPlay) {
      bleu.play();
    } else {
      if (!bleu.isPlaying() && needtoplaybleu) {
        bleu.play();
      }
    }

    break;
  }
  strokeWeight(10);
  fill(colbc);
  ellipse(width / 2, height / 2, width / 3, height / 3);
  noFill();
  ellipse(width / 2, height / 2, width - 10, height - 10);
  stroke(0);
  line(width / 2, height / 3, width / 2, 5);
  line(width / 2, height - height / 3, width / 2, height - 5);
  line(width / 3, height / 2, 5, height / 2);
  line(width - width / 3, height / 2, width - 5, height / 2);
}

void verify() {
  /*
  Vérifie pour savoir si on doit passer dans l'état de GameOver
   ou non en vérifiant si la liste d'où l'utilisateur a cliqué,
   est pareil que le début de la liste tiré au sort
   */
  if ((indcareclic.size() <= indcarejeux.size())) {   // Vérification en temps réel, 60*fois seconde
    for (int i = 0; i < indcareclic.size(); i++) {
      if (indcareclic.get(i) != indcarejeux.get(i)) {  // Si on a une différence, on arrête le jeu et on clean les listes
        isloosing = true;
        needToPlay = false;
        DiscordRichPresence rich = new DiscordRichPresence.Builder("GameOver").setBigImage("icon", "logo").build();
        DiscordRPC.discordUpdatePresence(rich);
        settingsShits.updateHighScore(score);
        indcarejeux.clear();
        indcareclic.clear();
      }
    }
  }

  if ((indcareclic.size() == indcarejeux.size())) {  // Si les 2 listes sont de la même taille, cela veut dire que l'utilisateur a fini un tour, donc on rajoute un arc de ercle à la séquence
    needToDraw = true;
    if (!isloosing) {
      score = indcareclic.size();
      indcareclic = new IntList();
      if (settingsShits.chaosMode) {
        int templenght = indcarejeux.size();
        indcarejeux = new IntList();
        for (int i = 0; i <= templenght; i++) {
          indcarejeux.append(int(random(0, 4)));  // Le chaos mode remplace tous les arc de cercle aléatoirement
        }
      } else {
        indcarejeux.append(int(random(0, 4)));    // Classique, on rajoute un arc de cercle
      }
      DiscordRichPresence rich = new DiscordRichPresence.Builder("Le Jeu").setDetails("Score: " + score).setBigImage("icon", "logo").build();
      DiscordRPC.discordUpdatePresence(rich);
      delay(500);  // Attend 500 Milisecondes pour laisser le temps à l'utilisateur
    }
  }

  if (needToDraw) {  // On dessine juste les arcs de cercle
    if (!isstilltaken) {
      delay(200);  // Attend 200 milliseondes entre chaque arc de cercle
      if (ind>indcarejeux.size() - 1) {
        ind = indcarejeux.size() - 1;
      }
      drawArc(indcarejeux.get(ind), false);
      ind++;
    }
    if (ind ==  indcarejeux.size()) {
      needToDraw = false;
      ind = 0;
    }
  }
}
