class SettingsJSON {
  PrintWriter newFile;
  boolean darkMode;
  boolean chaosMode;
  IntList listeParametres;
  JSONObject json;

  void loadSettings() {
    /* On stock tous les parametres dans un fichier json situé dans le dossier data.
    Chaque paramètres a sa variable, dans la liste on a des booléens convertie en entier qui sonr dans cette classe, ainsi que dans le fichier json. 
    */
    listeParametres = new IntList();
    try {
      json = loadJSONObject("data/settings.json");
      darkMode = json.getBoolean("darkmode");
      chaosMode = json.getBoolean("chaosmode");
    }
    catch (NullPointerException e) {
      newFile = createWriter("data/settings.json");
      newFile.println("{}");
      newFile.flush();
      newFile.close();
      json = loadJSONObject("data/settings.json");
      json.setBoolean("darkmode", false);
      json.setBoolean("chaosmode", false);
      saveJSONObject(json, "data/settings.json");
    }
    listeParametres.append(int(darkMode));
    listeParametres.append(int(chaosMode));
  }

  void changeSettings(String settingsToChange) {  // Que pour des booléens pour l'instant donc on prend le param et on l'inverse
    json = loadJSONObject("settings.json");
    json.setBoolean(settingsToChange, !json.getBoolean(settingsToChange));
    saveJSONObject(json, "data/settings.json");
  }

  void updateHighScore(int newScore) {  // On change juste le hight score si il est supérieur a l'ancien
    json = loadJSONObject("data/settings.json");
    try {
      int oldScore = json.getInt("highScore");
      if (oldScore < newScore) {
        json.setInt("highScore", newScore);
      }
    }
    catch(RuntimeException a) {
      println(a.getMessage());
      json.setInt("highScore", newScore);
    }
    saveJSONObject(json, "data/settings.json");
  }

  String readHightScore() {  // On revoie en chaine de caracteres le high score, si il est inexistant on revoie une erreur sans faire planter le programme
    json = loadJSONObject("data/settings.json");
    try {
      int score = json.getInt("highScore");
      return str(score);
    }
    catch(RuntimeException a) {
      return "Meilleur score Inexistant";
    }
  }
}
