class MainMenu {
  int fillPlayButton;
  int fillMenuButton;
  boolean isSettingsClick = false;
  boolean isPlayGame = false;
  boolean isSettings = false;
  boolean isDead = false;
  PFont comic;
  PImage logoDarkMode;
  PImage logoLightMode;
  PImage logoMasterclass;
  SettingsJSON settings;

  void draw() {
    // Même schéma que pour le menu du gameover mais cette fois avec des bouttons en plus
    settings = new SettingsJSON();
    settings.loadSettings();
    surface.setTitle("Menu");
    isPlayGame = false;
    isSettings = false;
    isDead = false;
    // Fond
    if (settings.darkMode) {
      background(38, 38, 38);
    } else {
      background(255);
    }
    // Rectangle pour jouer + logo
    rectMode(CORNER);
    imageMode(CENTER);
    fill(fillPlayButton);
    image(logoMasterclass, width/2, height/4, width, logoMasterclass.height/2);
    if (settings.darkMode) {
      //image(logoDarkMode, width/2, logoDarkMode.height/4, width, logoDarkMode.height/2);
      stroke(255);
      //fill(38,38,38);
    } else {
      //image(logoLightMode, width/2, logoLightMode.height/4, width, logoLightMode.height/2);
      stroke(0);
      //fill(255);
    }
    rect(width / 8, height / 2 + 45, width/2.666666667, height/8);
    // Rectangle pour paramètres
    strokeWeight(1);
    if (settings.darkMode) {
      stroke(255);
      //fill(38,38,38);
    } else {
      stroke(0);
      //fill(255);
    }
    fill(fillMenuButton);
    rect(width / 2, height / 2 + 45, width/2.666666667, height/8);

    textAlign(CENTER);
    textSize((width/2.666666667)/3.5);
    if (settings.darkMode) {
      fill(255);
    } else {
      fill(0);
    }
    text("Jouer", width / 3 - ((width/2.666666667)/30), height / 2 + height/6.5);

    textSize((width/2.666666667)/6);
    text("Paramètres", width - width / 3.25, height / 2 + 112);

    if (mouseX < width / 2 && mouseX > width/2-width/2.666666667 && mouseY > height / 2 + 45 && mouseY < height / 2 + 150) {// Bouton Gauche
      if (settings.darkMode) {
        fillPlayButton+=5;
        fillMenuButton-=5;
      } else {
        fillPlayButton-=5;
        fillMenuButton+=5;
      }
    } else if (mouseX > width / 2 && mouseX < width/2+width/2.666666667&& mouseY > height / 2 + 45 && mouseY < height / 2 + 150) {
      if (settings.darkMode) {
        fillMenuButton+=5;
        fillPlayButton-=5;
      } else {
        fillMenuButton-=5;
        fillPlayButton+=5;
      }
    } else {
      if (settings.darkMode) {
        fillMenuButton-=5;
        fillPlayButton-=5;
      } else {
        fillPlayButton+=5;
        fillMenuButton+=5;
      }
    }
    //if (mouseX > width / 2 && mouseY > height / 2 + 50 && mouseY < height / 2 + 150) {// Bouton droit
    //     isSettings = true;
    //}

    if (fillPlayButton > 127 && settings.darkMode) {
      fillPlayButton = 127;
    }
    if (fillPlayButton < 38 && settings.darkMode) {
      fillPlayButton = 38;
    }
    if (fillPlayButton < 127 && !settings.darkMode) {
      fillPlayButton = 127;
    }
    if (fillPlayButton > 255 && !settings.darkMode) {
      fillPlayButton = 255;
    }

    if (fillMenuButton < 38 && settings.darkMode) {
      fillMenuButton = 38;
    }
    if (fillMenuButton > 127 && settings.darkMode) {
      fillMenuButton = 127;
    }
    if (fillMenuButton < 127 && !settings.darkMode) {
      fillMenuButton = 127;
    }
    if (fillMenuButton > 255 && !settings.darkMode) {
      fillMenuButton = 255;
    }



    if (mousePressed) {
      if (mouseX < width / 2 && mouseX > width/2-width/2.666666667 && mouseY > height / 2 + 50 && mouseY < height / 2 + 150) {// Bouton Gauche
        isPlayGame = true;
      }
      if (mouseX > width / 2 && mouseY > height / 2 + 50 && mouseY < height / 2 + 150) {// Bouton droit
        isSettings = true;
      }
    }

    // Affichage du meilleur score
    textAlign(LEFT);
    textSize(width/32);
    text("meilleur score: " + settings.readHightScore(), 0, height-10);
  }
}
