import java.io.FilenameFilter;
import ddf.minim.*;
import ddf.minim.*;


AudioPlayer toPlay;
Minim minim;
DisposeHandler dh;
musicInfo infos;
PImage bg;
settingsMenu settings;
SettingsJSON settingsFile;
boolean inSettsMenu = false;
String[] filenames;
String fullPath;
int wichIsPlaying;
boolean isPaused;
float tempsChanson = 0;
int fps = 60;
int offsets = 0;
PImage iconeParams;
boolean isCharged=true;
StringList nomChanson;
Boolean pathIsExisting = true;
Boolean askedOnce = false;
int passageBoucle = 0;
int previousHeight;

void setup() {
  dh = new DisposeHandler(this);
  settings = new settingsMenu();
  settingsFile = new SettingsJSON();
  infos = new musicInfo();
  settingsFile.verifyIfFileExist();
  bg = loadImage("data/bg.jpg");
  int[] tailles = new int[2];
  tailles = settingsFile.loadSizeWindows();
  surface.setSize(tailles[0], tailles[1]);
  bg.resize(width, height);
  fullPath = settingsFile.loadFolder();
  surface.setIcon(loadImage("data/logo.png"));
  println(fullPath, "dosseir");
  if (fullPath == "" || fullPath == null) {
    pathIsExisting = false;
  }
  iconeParams = loadImage("data/iconparams.png");
  frameRate(fps);
  minim = new Minim(this);
  surface.setResizable(true);
  if (pathIsExisting) {
    refreshList();
  }
  previousHeight = height;
}

void draw() {
  int pwidth = width;
  int pheight = height;
  pwidth = constrain(pwidth, 800, width);
  pheight = constrain(pheight, 800, height);
  // println(previousHeight != height);
  if (previousHeight != height) {
    changeOffstses(-height, true);
    println('a');
  }
  surface.setSize(pwidth, pheight);
  imageMode(CORNER);
  image(bg, 0, 0, width, height);
  fill(255, 255, 255, 127);
  rect(0, height-100, width, 100);
  if (!pathIsExisting) {
    if (!askedOnce) {
      isCharged = false;
      selectFolder("Choisissez un dossier pour charger les musiques:", "folderInit");
      askedOnce = true;
    } else {
      textSize(48);
      text("Veuillez choisir un dossier\ncontenant les musiques pour continuer", 0, height/3);
      fill(0);
      rect(width/4, height/1.6, width/2, height/8);  //rect(200, 500, 400, 100);
      fill(255);
      textSize((width/4 + height/8)/6);
      text("choisir un dossier", width/4+25, height/1.6+70);
    }
  } else {
    if (filenames.length!=0 && isCharged) {
      //println(width, height);
      int y = 0 +offsets;
      textSize(40);
      for (int i = 0; i <  filenames.length; i++) {
        fill(255, 255, 255, 200);
        rect(0, y, width/2, 100, 28);
        fill(0);
        //text(filenames[i].getMetaData().title(), 10,y+50);
        if (nomChanson.get(i) != "") {
          text(nomChanson.get(i), 10, y+50);
        } else {
          text(filenames[i].substring( 0, filenames[i].length()-4 ), 10, y+50);
        }
        y+=100;
      }

      if (toPlay.isPlaying() || isPaused) {
        textSize(25);
        textAlign(CENTER);
        text(filenames[wichIsPlaying].substring( 0, filenames[wichIsPlaying].length()-4 ), width/2, height-75);

        infos.promptInfo();
      }
      textAlign(LEFT);
      if (toPlay.isPlaying()) {
        tempsChanson = toPlay.position()/1000.0;
      }
      textSize(40);
      //println("minutes: ", int(tempsChanson/60), "secondes: ", int(tempsChanson%60));
      if (int(tempsChanson%60) < 10) {
        text(str(int(tempsChanson/60))+":0"+str(int(tempsChanson%60)), 10, height-65);
      } else {
        text(str(int(tempsChanson/60))+":"+str(int(tempsChanson%60)), 10, height-65);
      }
      fill(255, 255, 255, 127);
      rect(10, height-50, 200, 5);
      fill(255, 0, 0, 255);
      rect(10, height-50, 200 * (tempsChanson / (toPlay.length()/1000.0)), 5);
      ellipseMode(CORNER);

      fill(255, 255, 255, 255);
      ellipse(200 * (tempsChanson / (toPlay.length()/1000.0)) + 7.5, height-52.5, 10, 10);
      //println(tempsChanson, toPlay.length()/1000.0, tempsChanson / (toPlay.length()/1000.0));
      if (tempsChanson / (toPlay.length()/1000.0) > 0.991) {
        wichIsPlaying++;
        changeMusique();
      }
      //inSettsMenu = settingsMenu.getRemoveMenu();*/
    } else {
      //println(width, height);
      textSize(width/10);
      text("Pas de chansons\ndisponible dans\nce répertoire", 0, height/7);
      triangle(width/2-20, height-50, width/2-20, height-25, width/2+10, height - 37.5);

      triangle(width/2-100, height-50, width/2-100, height-25, width/2-120, height - 37.5);
      triangle(width/2-20+100, height-50, width/2-20+100, height-25, width/2+100, height - 37.5);
      textSize(40);
      //println("minutes: ", int(tempsChanson/60), "secondes: ", int(tempsChanson%60));
      if (int(tempsChanson%60) < 10) {
        text(str(int(tempsChanson/60))+":0"+str(int(tempsChanson%60)), 10, height-65);
      } else {
        text(str(int(tempsChanson/60))+":"+str(int(tempsChanson%60)), 10, height-65);
      }
      fill(255, 255, 255, 127);
      rect(10, height-50, 200, 5);
      fill(255, 255, 255, 255);
      rect(10, height-50, 0, 5);
      ellipseMode(CORNER);
      ellipse(7.5, height-52.5, 10, 10);
    }
    if (height-100 > (filenames.length-1) * 100 + 100) {
      offsets = 0;
    }
  }
  rect(width/2-25, height-57.25, 40, 40);
  rect(width/2+70, height-57.25, 40, 40);
  rect(width/2-130, height-57.25, 40, 40);
  fill(0, 0, 0, 255);
  if (pathIsExisting && filenames.length!=0 && isCharged) {
    if (!isPaused && toPlay.isPlaying()) {
      rect(width/2-20, height - 50, 10, 25);
      rect(width/2, height - 50, 10, 25);
    } else {
      triangle(width/2-20, height-50, width/2-20, height-25, width/2+10, height - 37.5);
    }
  } else {
    triangle(width/2-20, height-50, width/2-20, height-25, width/2+10, height - 37.5);
  }
  triangle(width/2-100, height-50, width/2-100, height-25, width/2-120, height - 37.5);
  triangle(width/2-100, height-50, width/2-100, height-25, width/2-120, height - 37.5);
  triangle(width/2-20+95, height-50, width/2-20+95, height-25, width/2+95, height - 37.5);
  triangle(width/2-20+110, height-50, width/2-20+110, height-25, width/2+110, height - 37.5);
  imageMode(CENTER);
  rectMode(CENTER);
  fill(0, 0, 0, 0);
  rect(width - 50, height - 50, 100, 100);
  image(iconeParams, width-50, height - 50, 75, 75);
  rectMode(CORNER);
  if (inSettsMenu) {
    settings.settings();
  }
  previousHeight = height;
}

void mousePressed() {
  if (isCharged) {
    if (!inSettsMenu && filenames.length!=0) {
      if (mouseX > width/2+70 && mouseX < width/2 +70 + 40 && mouseY > height-57.25 && mouseY < height-57.25 + 40) {
        wichIsPlaying++;
        changeMusique();
      } else if (mouseX>width/2-130 && mouseY > height-57.25 && mouseX < width/2-130+40 && mouseY < height-57.25 + 40) {
        if ((tempsChanson / (toPlay.length()/1000.0)) * 100 > 2) {
          toPlay.rewind();
          tempsChanson = 0;
        } else {
          wichIsPlaying--;
          changeMusique();
        }
      } else if (mouseX > width/2-25 && mouseX < width/2 - 25 + 40 && mouseY > height-57.25 && mouseY < height-57.25 + 40) {
        if (toPlay.isPlaying()) {
          toPlay.pause();
          isPaused = true;
        } else {
          toPlay.play();
          isPaused = false;
        }
      } else if (mouseX < width && mouseX > width - 100 && mouseY > height-100 && mouseY < height) {
        inSettsMenu = true;
      } else if (mouseY < height-100) {
        for (int i = 0; i <  filenames.length; i++) {
          if (mouseY > (i * 100 + offsets) && mouseY < (i * 100 + 100 + offsets)) {
            if (toPlay.isPlaying()) {
              toPlay.close();
            }
            tempsChanson = 0;
            toPlay = minim.loadFile(fullPath +"/" + filenames[i]);
            toPlay.play();

            isPaused = false;
            wichIsPlaying = i;
          }
        }
      }
    } else if (!inSettsMenu) {
      if (mouseX < width && mouseX > width - 100 && mouseY > height-100 && mouseY < height) {
        inSettsMenu = true;
      }
    } else {
      if (mouseX < width-10 && mouseX >width-50 && mouseY > 10 && mouseY < 50) {
        inSettsMenu=false;
      } else if (mouseX > 10 && mouseX < width/2 && mouseY > 10 && mouseY < height/8) {
        isCharged=false;
        selectFolder("Nouveau Dossier:", "changeFolder");
      }
    }
  } else {  //vrect(width/4, height/1.6, width/2, height/8)
    if (mouseX > width/4 && mouseX < width/4+width/2 && mouseY > height/1.6 && mouseY < height/1.6+height/8) {
      selectFolder("Choisissez un dossier pour charger les musiques:", "folderInit");
    }
  }
}

void changeFolder(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
    refreshList();
  } else {
    println("User selected " + selection.getAbsolutePath());
    settingsFile.changeFoldera(selection.getAbsolutePath());

    pathIsExisting = true;
    refreshList();
  }
}

void refreshList() {
  fullPath = settingsFile.loadFolder();
  filenames = loadFilenames(fullPath);
  filenames = sort(filenames);
  nomChanson = new StringList();
  for (int i = 0; i <  filenames.length; i++) {
    toPlay = minim.loadFile(fullPath +"/" + filenames[i]);
    AudioMetaData meta;
    meta = toPlay.getMetaData();
    nomChanson.append(meta.title());
  }
  minim.stop();
  minim = new Minim(this);
  wichIsPlaying = filenames.length-1;
  isCharged=true;
}

void folderInit(File selection) {
  if (selection != null) {
    settingsFile.changeFoldera(selection.getAbsolutePath());
    fullPath = selection.getAbsolutePath();
    filenames = loadFilenames(fullPath);
    filenames = sort(filenames);
    nomChanson = new StringList();
    for (int i = 0; i <  filenames.length; i++) {
      toPlay = minim.loadFile(fullPath +"/" + filenames[i]);
      AudioMetaData meta;
      meta = toPlay.getMetaData();
      nomChanson.append(meta.title());
    }
    minim = new Minim(this);
    wichIsPlaying = filenames.length-1;
    pathIsExisting = true;
    isCharged=true;
  } else {
    isCharged = false;
  }
}

void mouseWheel(MouseEvent event) {
  if (!inSettsMenu) {
    float e = event.getCount();
    if (e == -1) {
      println("vers le bas");
      changeOffstses(10, false);
    } else if ( e == 1) {
      println("vers le haut");
      changeOffstses(-10, false);
    }
  }
}

void keyPressed() {
  println(key, int(keyCode));
  if (keyCode == 38) {
    changeOffstses(10, false);
  } else if (keyCode == 40) {
    changeOffstses(-10, false);
  }
  if (key == ' ' && !inSettsMenu && filenames.length!=0) {
    if (toPlay.isPlaying()) {
      toPlay.pause();
      isPaused = true;
    } else {
      toPlay.play();
      isPaused = false;
    }
  }
}

void changeOffstses(int facteur, boolean needTheThing) {
  if (!inSettsMenu) {
    println(needTheThing);
    if (needTheThing) {
      offsets = 0;
      println(offsets);
      while(!(height-100 > ((filenames.length+1) * 100)+100+offsets)){
        offsets-=10;
        println((filenames.length-1) * 100 + 100 + offsets, !(height-100 > (filenames.length) * 100 + 100 + offsets));
      }
      println(offsets);
    } else {
      int poffests = offsets;
      offsets += facteur;
      if (offsets > 0) {
        offsets = 0;
      }
      println(height-100 > (filenames.length-1) * 100 + 100, height-100 > (filenames.length-1) * 100 + 100 + offsets);
      if (height-100 > (filenames.length-1) * 100 + 100) {
        offsets = 0;
      }
      if (height-100 > ((filenames.length-1) * 100)+ 100 + offsets) {
        //offsets = height / ((filenames.length-1) * 100 + 100);
        offsets = poffests;
      }
      println(offsets, height/((filenames.length-3)));
    }
    
      println(offsets);
  }
}

void changeMusique() {
  if (wichIsPlaying < 0) {
    wichIsPlaying = filenames.length-1;
  } else if (wichIsPlaying > filenames.length-1) {
    wichIsPlaying = 0;
  }

  if (toPlay.isPlaying() && filenames.length!=0) {
    toPlay.close();
  }
  isPaused = false;
  tempsChanson = 0;
  toPlay = minim.loadFile(fullPath +"/" + filenames[wichIsPlaying]);
  toPlay.play();
}


String[] loadFilenames(String path) {
  File folder = new File(path);
  FilenameFilter filenameFilter = new FilenameFilter() {
    public boolean accept(File dir, String name) {
      return name.toLowerCase().endsWith(".mp3") || name.toLowerCase().endsWith(".wav") || name.toLowerCase().endsWith(".aiff") || name.toLowerCase().endsWith(".au") || name.toLowerCase().endsWith(".snd"); // change this to any extension you want
    }
  };
  return folder.list(filenameFilter);
}

public class DisposeHandler {

  DisposeHandler(PApplet pa)
  {
    pa.registerMethod("dispose", this);
  }

  public void dispose()
  {
    println("Closing sketch");
    settingsFile.writeSizeWindow();
    // Place here the code you want to execute on exit
  }
}
