export const version = () => "1.0.0";

/* TODO : Créer le modèle objet ici */

export const SensorType = {
  Temperature:"TEMPERATURE",
  Humidity:"HUMIDITY",
  Light:"LIGHT",
  Switch:"SWITCH",
  Door:"DOOR",
  FanSpeed:"FAN_SPEED",
  OnOff:"ON_OFF",
  Percent:"PERCENT"
};

export class Sensor {
  constructor(id, name, type, data) {
    this._id = id;
    this._name = name;
    this._type = type;
    this._data = data;
  }
}

export class Temperature extends Sensor {
  constructor(id, name, data) {
    super(id, name, SensorType.Temperature, data);
  }

  toString(){
    var r = "Capteur Temperature :\nid : "+this._id+"\nnom : "+this._name+"\n";
    var i;
    for(i = 0; i < this._nbValues; i++){
      r+="La temperature est de "+this._data._values[i]+" degres a la date "+this._data._labels[i]+"\n";
    }
    return r;
  }
}

export class OnOff extends Sensor {
  constructor(id, name, data) {
    super(id, name, SensorType.OnOff, data);
  }

  toString(){
    var r = "Capteur :\nid : "+this._id+"\nnom : "+this._name+"\n";
    var i;
    for(i = 0; i < this._nbValues; i++){
      r+="Le switch est "+this._data._values[i]+" a la date "+this._data._labels[i]+"\n";
    }
    return r;
  }
}

export class Percent extends Sensor {
  constructor(id, name, data) {
    super(id, name, SensorType.Percent, data);
  }

  toString(){
    var r = "Capteur :\nid : "+this._id+"\nnom : "+this._name+"\n";
    var i;
    for(i = 0; i < this._nbValues; i++){
      r+="Le pourcentage est de "+this._data._values[i]+" a la date "+this._data._labels[i]+"\n";
    }
    return r;
  }
}

export class Humidity extends Sensor {
  constructor(id, name, data) {
    super(id, name, SensorType.Humidity, data);
  }

  toString(){
    var r = "Capteur Humidite :\nid : "+this._id+"\nnom : "+this._name+"\n";
    var i;
    for(i = 0; i < this._data._values.length; i++){
      r+="L humidite est de "+this._data._values[i]+"% a la date "+this._data._labels[i]+"\n";
    }
    return r;
  }
}

export class Light extends Sensor {
  constructor(id, name, data) {
    super(id, name, SensorType.Light, data);
  }

  toString(){
    var r = "Capteur Luminosite :\nid : "+this._id+"\nnom : "+this._name+"\n";
    var i;
    for(i = 0; i < this._data._values.length; i++){
      r+="La luminosite est de "+this._data._values[i]+"% a la date "+this._data._labels[i]+"\n";
    }
    return r;
  }
}

export class Switch extends Sensor {
  constructor(id, name, data) {
    super(id, name, SensorType.Switch, data);
  }

  toString(){
    var r = "Capteur Switch :\nid : "+this._id+"\nnom : "+this._name+"\n";
    if(this._data._value === 1){
      r+="L interrupteur est ouvert !\n";
    }else{
      r+="L interrupteur est ferme !\n";
    }
    return r;
  }
}

export class Door extends Sensor {
  constructor(id, name, data) {
    super(id, name, SensorType.Door, data);
  }

  toString(){
    var r = "Capteur Door :\nid : "+this._id+"\nnom : "+this._name+"\n";
    if(this._data._value === 1){
      r+="La porte est ouverte !\n";
    }else{
      r+="La porte est ferme !\n";
    }
    return r;
  }
}

export class FanSpeed extends Sensor {
  constructor(id, name, data) {
    super(id, name, SensorType.FanSpeed, data);
  }

  toString(){
    var r = "Capteur FanSpeed :\nid : "+this._id+"\nnom : "+this._name+"\n";
    var i;
    for(i = 0; i < this._data._values.length; i++){
      r+="La vitesse du ventilateur est de "+this._data._values[i]+"tours/min a la date "+this._data._labels[i]+"\n";
    }
    return r;
  }
}

export class Data {
  //constructor() {}
}

export class TimeSeries extends Data{
  constructor(values, labels) {
    super();
    this._nbValues = 1;
    this._values = [];
    this._labels = [];
    this._values[0] = values;
    this._labels[0] = labels;
  }

  add(values, labels) {
    this._values[this._nbValues] = values;
    this._labels[this._nbValues] = labels;
    this._nbValues++;
  }

  numberOfValues(){
    return this._nbValues;
  }

  dateOfLastValue(){
    return this._labels[this._values.length-1];
  }

  lastValue(){
    return this._values[this._values.length-1];
  }

  getHisto(){
    var s ="<ul>";
    if(this._nbValues > 10){
      for (var i = this._values.length; i > this._values.length-10; i--) {
        if(this._values[i-1] === "ON" || this._values[i-1] === "OFF" ){
          s+="<li>"+this._values[i-1]+"</li>";
        }else{
          s+="<li>"+Math.round(this._values[i-1]*100)/100+"</li>";
        }
      }
    }else{
      for (var i = this._values.length; i > 0; i--) {
        if(this._values[i-1] === "ON" || this._values[i-1] === "OFF" ){
          s+="<li>"+this._values[i-1]+"</li>";
        }else{
          s+="<li>"+Math.round(this._values[i-1]*100)/100+"</li>";
        }
      }
    }
    return s+"</ul>";
  }

  meanOfAllValues(){
    var i,sum = 0;
    for(i = 0; i < this._nbValues; i++){
      sum+=parseFloat(this._values[i]);
    }
    return sum/this._nbValues;
  }
}

export class Datum extends Data {
  constructor(value) {
    super();
    this._value = value;
  }

  numberOfValues(){
    return 1;
  }
}
