import React from 'react'
import ReactDOM from 'react-dom'
import renderHTML from 'react-render-html'
import {
  BrowserRouter as Router,
  Route,
  Link
} from 'react-router-dom'
import './App.css';
import {Temperature, TimeSeries, OnOff, Percent} from './objectModel.js';


const mqtt = require('mqtt')
const client = mqtt.connect('ws://127.0.0.1:1234');
var arraySensors = [];

client.on('connect', () => {
  client.subscribe('value/#');
})

client.on('message', (topic, message) => {

  var name = topic.substring(6);
  var obj = JSON.parse(message);
  var value = obj["value"];
  var type = obj["type"];


  switch(type){
    case 'TEMPERATURE':
      if (arraySensors[name] === undefined) {
        //console.log("creation");
        arraySensors[name] = new Temperature(name, type, new TimeSeries(value, Date()));
      }else{
        //console.log("existe deja ");
        arraySensors[name]._data.add(value, Date());
      }
      //console.log(arraySensors[name]);
      ReactDOM.render(<BasicExample arraySensor={arraySensors[name]}/>, document.getElementById('root'));
    break;

    case 'ON_OFF':
      if (arraySensors[name] === undefined) {
        //console.log("creation");
        arraySensors[name] = new OnOff(name, type, new TimeSeries(value, Date()));
      }else{
        //console.log("existe deja ");
        arraySensors[name]._data.add(value, Date());
      }
      ReactDOM.render(<BasicExample arraySensor={arraySensors[name]}/>, document.getElementById('root'));
    break;

    case 'PERCENT':
      if (arraySensors[name] === undefined) {
        //console.log("creation");
        arraySensors[name] = new Percent(name, type, new TimeSeries(value, Date()));
      }else{
        //console.log("existe deja ");
        arraySensors[name]._data.add(value, Date());
      }
      ReactDOM.render(<BasicExample arraySensor={arraySensors[name]}/>, document.getElementById('root'));
    break;
    default:

  }

})

class OnOffs extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      id : props.sensor._id,
      name : props.sensor._name,
      type : "ON_OFF",
      array: props.sensor._data
    };
  }

  render(){
    return(
      <div>
        <p>Capteur : {this.state.id}</p>
        <p>Type : {this.state.type}</p>
        <p>Valeur actuelle : {this.state.array.lastValue()}</p>
        <p>Historique : {renderHTML(this.state.array.getHisto())}</p>
      </div>
    );
  }
}

class TemperatureA111 extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      id : props.sensor._id,
      name : props.sensor._name,
      type : "TEMPERATURE",
      array: props.sensor._data,
    };
  }

  render(){
    return(
      <div>
        <p>Capteur : {this.state.id}</p>
        <p>Type : {this.state.type}</p>
        <p>Valeur actuelle : {Math.round(this.state.array.lastValue()*100)/100}°</p>
        <p>Historique : {renderHTML(this.state.array.getHisto())}</p>
      </div>
    );
  }
}

class TemperatureChambre extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      id : props.sensor._id,
      name : props.sensor._name,
      type : "TEMPERATURE",
      array: props.sensor._data,
    };
  }

  render(){
    return(
      <div>
        <p>Capteur : {this.state.id}</p>
        <p>Type : {this.state.type}</p>
        <p>Valeur actuelle : {Math.round(this.state.array.lastValue()*100)/100}°</p>
        <p>Historique : {renderHTML(this.state.array.getHisto())}</p>
      </div>
    );
  }
}

class Attention extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      id : props.sensor._id,
      name : props.sensor._name,
      type : "PERCENT",
      array: props.sensor._data
    };
  }

  render(){
    return(
      <div>
        <p>Capteur : {this.state.id}</p>
        <p>Type : {this.state.type}</p>
        <p>Valeur actuelle : {Math.round(this.state.array.lastValue()*100)} %</p>
        <p>Historique : {renderHTML(this.state.array.getHisto())}</p>
      </div>
    );
  }
}

class BasicExample extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      arraysSensor : props.arraySensor,
      arrayYeux : [],
      arrayAttention : [],
      arrayChambre : [],
      arrayA111 : []
    }
  }

  componentWillReceiveProps(nextProps){
    console.log(nextProps);
    switch (nextProps.arraySensor._id) {
      case "MesYeux":
        this.setState({
          arrayYeux : nextProps.arraySensor
        });
      break;

      case "MonAttention":
        this.setState({
          arrayAttention : nextProps.arraySensor
        });
      break;

      case "temperatureSalleA111":
        this.setState({
          arrayA111 : nextProps.arraySensor
        });
      break;

      case "temperatureChambre":
        this.setState({
          arrayChambre : nextProps.arraySensor
        });
      break;

    }
  }

  render(){
    return(
      <Router>
        <div id="body">
          <div id="head">
            <h1>URL du Brocker :</h1>
            <input type="text" name="brocker" defaultValue="ws://127.0.0.1:1234" disabled/>
            <br /><br />
          </div>

          <div id="left">
            <ul>
              <li><Link to="/temperatureChambre">Temperature Chambre</Link></li><br/>
              <li><Link to="/temperatureA111">Temperature Salle A111</Link></li><br/>
              <li><Link to="/attention">Mon Attention</Link></li><br/>
              <li><Link to="/yeux">Mes Yeux</Link></li>
            </ul>
          </div>

          <div id="content">
            <Route path="/yeux" component={() => <OnOffs sensor={this.state.arrayYeux} />}/>
            <Route path="/temperatureChambre" component={() => <TemperatureChambre sensor={this.state.arrayChambre} />}/>
            <Route path="/temperatureA111" component={() => <TemperatureA111 sensor={this.state.arrayA111} />}/>
            <Route path="/attention" component={() => <Attention sensor={this.state.arrayAttention} />}/>
          </div>
        </div>
      </Router>
    );
  }
}


export default BasicExample
