import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public class METBubulle {

	public String fichier;
	public ArrayList<Particule> alParticules;

	public Controleur c;

	public METBubulle(String fichier, Controleur c) {
		this.fichier = fichier;
		alParticules = new ArrayList<Particule>();

		this.c = c;
	}

	public void lectureDonnees() {

		try {
			FileReader fr;
			fr = new FileReader(System.getProperty("user.dir")+"/src/test");
			BufferedReader br = new BufferedReader(fr);
			String s;
			while ((s = br.readLine()) != null) {
				// System.out.println(s);
				Scanner scanner = new Scanner(s);
				Particule p = new Particule(Double.parseDouble(scanner.next("[\\S ]+")),
						Double.parseDouble(scanner.next("[\\S ]+")), Double.parseDouble(scanner.next("[\\S ]+")),
						Double.parseDouble(scanner.next("[\\S ]+")), Double.parseDouble(scanner.next("[\\S ]+")));
				// System.out.println(p);
				c.addParticule(p);
			}
			fr.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void rechercheGroupe() {
		Particule particuleT1 = c.getListeParticule().get(2);
		Particule voisinPotentiel = null;

		double zRef = particuleT1.getZ();

		double diffX = 100000;
		double diffY = 100000;

		for (Particule candidate : c.getListeParticule()) {
			if (candidate.getZ() > zRef /* &&( candidate.getZ()-zRef) < 10 */ ) {
				double diffXCandidate = candidate.getX() - particuleT1.getX();
				double diffYCandidate = candidate.getY() - particuleT1.getY();

				if (diffXCandidate < diffX && diffYCandidate < diffY
						|| diffXCandidate < diffX && diffY == diffYCandidate
						|| diffXCandidate == diffX && diffYCandidate < diffY) {

					voisinPotentiel = candidate;
					diffX = diffXCandidate;
					diffY = diffYCandidate;
				}
			}
		}

		// particuleT1.setColor(Color.RED);
		// if(voisinPotentiel!=null)
		// voisinPotentiel.setColor(Color.RED);

		// System.out.println(particuleT1);
		// System.out.println(voisinPotentiel);

	}

	public void plusProcheVoisin() {
		Particule nonVoisin = new Particule(.0,.0,.0,.0,.0);
		HashMap<Double, ArrayList<Particule>> hashmap = new HashMap<Double, ArrayList<Particule>>();

		for (Particule p1 : this.c.alParticules) {
			Double plusPetiteDistance = 1000.00;
			for (Particule p2 : this.c.alParticules) {
				if (!p1.estEgal(p2)) {
					Double distanceP1P2 = calculDistance(p1, p2);
					if (distanceP1P2 < plusPetiteDistance && !p2.getDejaVoisin()) {
						plusPetiteDistance = distanceP1P2;
						System.out.println(plusPetiteDistance);
						// System.out.println("plus petite distance trouv");
						if (p1.getPlusProcheVoisin() != null && plusPetiteDistance < .6) {
							if (calculPente(p1, p2) <= 20 && calculPente(p1, p2) > .0 && !calculPente(p1, p2).isNaN()
									) {
//								p1.getPlusProcheVoisin().setDejaVoisin(false);
//								p1.enleverVoisin();
								p1.ajouterVoisin(p2);

							}
						}
						
					}

					double vitesse = distanceP1P2;

					BigDecimal bd = new BigDecimal(vitesse);
					bd = bd.setScale(3, BigDecimal.ROUND_DOWN);
					vitesse = bd.doubleValue();
					p1.setVitesse(vitesse);

				} else {
					p1.ajouterVoisin(p1);
					p1.setEligibleVoisin(false);
				}
			}

			if (hashmap.containsKey(p1.getVitesse())) {
				hashmap.get(p1.getVitesse()).add(p1);
			} else {
				hashmap.put(p1.getVitesse(), new ArrayList<Particule>());
				hashmap.get(p1.getVitesse()).add(p1);
			}
		}

		Particule p1 = this.c.alParticules.get(40);
		p1.setColor(Color.GREEN);
		System.out.println("distance p1 et son voisin : " + calculDistance(p1, p1.getPlusProcheVoisin()));
		Particule p2 = p1.getPlusProcheVoisin();
		p2.setColor(Color.BLUE);
		System.out.println("distance p2 et son voisin : " + calculDistance(p2, p2.getPlusProcheVoisin()));
		Particule p3 = p2.getPlusProcheVoisin();
		p3.setColor(Color.RED);
		// System.out.println("Particule P1 :" + p1 + "Particule P2 :" + p2 +
		// "Particule p3 : " +p3);
		// System.out.println("p1 deja voisin " + p1.getDejaVoisin());
		Particule p4 = p3.getPlusProcheVoisin();
		p4.setColor(Color.YELLOW);
//		System.out.println("distance p3 et son voisin : " + calculDistance(p3, p3.getPlusProcheVoisin()));

	}

	private Double calculPente(Particule p1, Particule p2) {
		double angle = 0;
		double produitScalNormalise = ((p1.getX() / p1.getNorme()) * (p2.getX() / p2.getNorme()))
				+ ((p1.getY() / p1.getNorme()) * (p2.getY() / p2.getNorme()))
				+ ((p1.getZ() / p1.getNorme()) * (p2.getZ() / p2.getNorme()));
		angle = Math.toDegrees(Math.acos(produitScalNormalise));
		return angle;
	}

	private Double calculDistance(Particule p1, Particule p2) {
		Double distance = Math.sqrt(Math.pow((p2.getX() - p1.getX()), 2) + Math.pow((p2.getY() - p1.getY()), 2)
				+ Math.pow((p2.getZ() - p1.getZ()), 2));
		return distance;
	}

}
