/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.graphstream.stream.file.FileSourceXML;

public class FileSourceGraphML
extends FileSourceXML {
    private static final Logger LOGGER = Logger.getLogger(FileSourceGraphML.class.getName());
    protected GraphMLParser parser;

    @Override
    protected void afterStartDocument() throws IOException, XMLStreamException {
        this.parser = new GraphMLParser();
        this.parser.__graphml();
    }

    @Override
    protected void beforeEndDocument() throws IOException, XMLStreamException {
        this.parser = null;
    }

    @Override
    public boolean nextEvents() throws IOException {
        return false;
    }

    protected class GraphMLParser
    extends FileSourceXML.Parser
    implements GraphMLConstants {
        protected HashMap<String, GraphMLConstants.Key> keys = new HashMap();
        protected Stack<String> graphId = new Stack();
        protected int graphCounter = 0;

        private Object getValue(GraphMLConstants.Data data) {
            return this.getValue(data.key, data.value);
        }

        private Object getValue(GraphMLConstants.Key key, String value) {
            switch (key.type) {
                case BOOLEAN: {
                    return Boolean.parseBoolean(value);
                }
                case INT: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case STRING: {
                    return value;
                }
            }
            return value;
        }

        private Object getDefaultValue(GraphMLConstants.Key key) {
            switch (key.type) {
                case BOOLEAN: {
                    return Boolean.TRUE;
                }
                case INT: {
                    if (key.def != null) {
                        return Integer.valueOf(key.def);
                    }
                    return 0;
                }
                case LONG: {
                    if (key.def != null) {
                        return Long.valueOf(key.def);
                    }
                    return 0L;
                }
                case FLOAT: {
                    if (key.def != null) {
                        return Float.valueOf(key.def);
                    }
                    return Float.valueOf(0.0f);
                }
                case DOUBLE: {
                    if (key.def != null) {
                        return Double.valueOf(key.def);
                    }
                    return 0.0;
                }
                case STRING: {
                    if (key.def != null) {
                        return key.def;
                    }
                    return "";
                }
            }
            return key.def != null ? key.def : Boolean.TRUE;
        }

        private void __graphml() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "graphml");
            e = FileSourceGraphML.this.getNextEvent();
            if (FileSourceGraphML.this.isEvent(e, 1, "desc")) {
                FileSourceGraphML.this.pushback(e);
                this.__desc();
                e = FileSourceGraphML.this.getNextEvent();
            }
            while (FileSourceGraphML.this.isEvent(e, 1, "key")) {
                FileSourceGraphML.this.pushback(e);
                this.__key();
                e = FileSourceGraphML.this.getNextEvent();
            }
            while (FileSourceGraphML.this.isEvent(e, 1, "data") || FileSourceGraphML.this.isEvent(e, 1, "graph")) {
                FileSourceGraphML.this.pushback(e);
                if (FileSourceGraphML.this.isEvent(e, 1, "data")) {
                    this.__data();
                } else {
                    this.__graph();
                }
                e = FileSourceGraphML.this.getNextEvent();
            }
            FileSourceGraphML.this.checkValid(e, 2, "graphml");
        }

        private String __desc() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "desc");
            String desc = this.__characters();
            e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 2, "desc");
            return desc;
        }

        private GraphMLConstants.Locator __locator() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "locator");
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            GraphMLConstants.Locator loc = new GraphMLConstants.Locator();
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.LocatorAttribute attribute = GraphMLConstants.LocatorAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case XMLNS_XLINK: {
                            loc.xlink = a.getValue();
                            break;
                        }
                        case XLINK_HREF: {
                            loc.href = a.getValue();
                            break;
                        }
                        case XLINK_TYPE: {
                            loc.type = a.getValue();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    FileSourceGraphML.this.newParseError(e, false, "invalid locator attribute '%s'", a.getName().getLocalPart());
                }
            }
            e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 2, "locator");
            if (loc.href == null) {
                FileSourceGraphML.this.newParseError(e, true, "locator requires an href", new Object[0]);
            }
            return loc;
        }

        private void __key() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "key");
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            String id = null;
            GraphMLConstants.KeyDomain domain = GraphMLConstants.KeyDomain.ALL;
            GraphMLConstants.KeyAttrType type = GraphMLConstants.KeyAttrType.STRING;
            String name = null;
            String def = null;
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.KeyAttribute attribute = GraphMLConstants.KeyAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case ID: {
                            id = a.getValue();
                            break;
                        }
                        case FOR: {
                            try {
                                domain = GraphMLConstants.KeyDomain.valueOf(FileSourceGraphML.this.toConstantName(a.getValue()));
                            }
                            catch (IllegalArgumentException ex) {
                                FileSourceGraphML.this.newParseError(e, false, "invalid key domain '%s'", a.getValue());
                            }
                            break;
                        }
                        case ATTR_TYPE: {
                            try {
                                type = GraphMLConstants.KeyAttrType.valueOf(FileSourceGraphML.this.toConstantName(a.getValue()));
                            }
                            catch (IllegalArgumentException ex) {
                                FileSourceGraphML.this.newParseError(e, false, "invalid key type '%s'", a.getValue());
                            }
                            break;
                        }
                        case ATTR_NAME: {
                            name = a.getValue();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    FileSourceGraphML.this.newParseError(e, false, "invalid key attribute '%s'", a.getName().getLocalPart());
                }
            }
            e = FileSourceGraphML.this.getNextEvent();
            if (FileSourceGraphML.this.isEvent(e, 1, "default")) {
                def = this.__characters();
                e = FileSourceGraphML.this.getNextEvent();
                FileSourceGraphML.this.checkValid(e, 2, "default");
                e = FileSourceGraphML.this.getNextEvent();
            }
            FileSourceGraphML.this.checkValid(e, 2, "key");
            if (id == null) {
                FileSourceGraphML.this.newParseError(e, true, "key requires an id", new Object[0]);
            }
            if (name == null) {
                name = id;
            }
            GraphMLConstants.Key k = new GraphMLConstants.Key();
            k.name = name;
            k.domain = domain;
            k.type = type;
            k.def = def;
            this.keys.put(id, k);
        }

        private GraphMLConstants.Port __port() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "port");
            GraphMLConstants.Port port = new GraphMLConstants.Port();
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.PortAttribute attribute = GraphMLConstants.PortAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case NAME: {
                            port.name = a.getValue();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    FileSourceGraphML.this.newParseError(e, false, "invalid attribute '%s' for '<port>'", a.getName().getLocalPart());
                }
            }
            if (port.name == null) {
                FileSourceGraphML.this.newParseError(e, true, "'<port>' element requires a 'name' attribute", new Object[0]);
            }
            if (FileSourceGraphML.this.isEvent(e = FileSourceGraphML.this.getNextEvent(), 1, "desc")) {
                FileSourceGraphML.this.pushback(e);
                port.desc = this.__desc();
            } else {
                while (FileSourceGraphML.this.isEvent(e, 1, "data") || FileSourceGraphML.this.isEvent(e, 1, "port")) {
                    if (FileSourceGraphML.this.isEvent(e, 1, "data")) {
                        FileSourceGraphML.this.pushback(e);
                        GraphMLConstants.Data data = this.__data();
                        port.datas.add(data);
                    } else {
                        FileSourceGraphML.this.pushback(e);
                        GraphMLConstants.Port portChild = this.__port();
                        port.ports.add(portChild);
                    }
                    e = FileSourceGraphML.this.getNextEvent();
                }
            }
            e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 2, "port");
            return port;
        }

        private GraphMLConstants.EndPoint __endpoint() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "endpoint");
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            GraphMLConstants.EndPoint ep = new GraphMLConstants.EndPoint();
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.EndPointAttribute attribute = GraphMLConstants.EndPointAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case NODE: {
                            ep.node = a.getValue();
                            break;
                        }
                        case ID: {
                            ep.id = a.getValue();
                            break;
                        }
                        case PORT: {
                            ep.port = a.getValue();
                            break;
                        }
                        case TYPE: {
                            try {
                                ep.type = GraphMLConstants.EndPointType.valueOf(FileSourceGraphML.this.toConstantName(a.getValue()));
                                break;
                            }
                            catch (IllegalArgumentException ex) {
                                FileSourceGraphML.this.newParseError(e, false, "invalid end point type '%s'", a.getValue());
                            }
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    FileSourceGraphML.this.newParseError(e, false, "invalid attribute '%s' for '<endpoint>'", a.getName().getLocalPart());
                }
            }
            if (ep.node == null) {
                FileSourceGraphML.this.newParseError(e, true, "'<endpoint>' element requires a 'node' attribute", new Object[0]);
            }
            if (FileSourceGraphML.this.isEvent(e = FileSourceGraphML.this.getNextEvent(), 1, "desc")) {
                FileSourceGraphML.this.pushback(e);
                ep.desc = this.__desc();
            }
            e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 2, "endpoint");
            return ep;
        }

        private GraphMLConstants.Data __data() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "data");
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            String key = null;
            String id = null;
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.DataAttribute attribute = GraphMLConstants.DataAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case KEY: {
                            key = a.getValue();
                            break;
                        }
                        case ID: {
                            id = a.getValue();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    FileSourceGraphML.this.newParseError(e, false, "invalid attribute '%s' for '<data>'", a.getName().getLocalPart());
                }
            }
            if (key == null) {
                FileSourceGraphML.this.newParseError(e, true, "'<data>' element must have a 'key' attribute", new Object[0]);
            }
            String value = this.__characters();
            e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 2, "data");
            if (!this.keys.containsKey(key)) {
                FileSourceGraphML.this.newParseError(e, true, "unknown key '%s'", key);
            }
            GraphMLConstants.Data d = new GraphMLConstants.Data();
            d.key = this.keys.get(key);
            d.id = id;
            d.value = value;
            return d;
        }

        private void __graph() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "graph");
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            String id = null;
            String desc = null;
            boolean directed = false;
            boolean directedSet = false;
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.GraphAttribute attribute = GraphMLConstants.GraphAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case ID: {
                            id = a.getValue();
                            break;
                        }
                        case EDGEDEFAULT: {
                            if (a.getValue().equals("directed")) {
                                directed = true;
                            } else if (a.getValue().equals("undirected")) {
                                directed = false;
                            } else {
                                FileSourceGraphML.this.newParseError(e, true, "invalid 'edgedefault' value '%s'", a.getValue());
                            }
                            directedSet = true;
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    FileSourceGraphML.this.newParseError(e, false, "invalid node attribute '%s'", a.getName().getLocalPart());
                }
            }
            if (!directedSet) {
                FileSourceGraphML.this.newParseError(e, false, "graph requires attribute 'edgedefault'", new Object[0]);
            }
            String gid = "";
            if (this.graphId.size() > 0) {
                gid = this.graphId.peek() + ":";
            }
            gid = id != null ? gid + id : gid + Integer.toString(this.graphCounter++);
            this.graphId.push(gid);
            e = FileSourceGraphML.this.getNextEvent();
            if (FileSourceGraphML.this.isEvent(e, 1, "desc")) {
                FileSourceGraphML.this.pushback(e);
                desc = this.__desc();
                FileSourceGraphML.this.sendGraphAttributeAdded(FileSourceGraphML.this.sourceId, "desc", desc);
                e = FileSourceGraphML.this.getNextEvent();
            }
            if (FileSourceGraphML.this.isEvent(e, 1, "locator")) {
                FileSourceGraphML.this.pushback(e);
                this.__locator();
                e = FileSourceGraphML.this.getNextEvent();
            } else {
                while (FileSourceGraphML.this.isEvent(e, 1, "data") || FileSourceGraphML.this.isEvent(e, 1, "node") || FileSourceGraphML.this.isEvent(e, 1, "edge") || FileSourceGraphML.this.isEvent(e, 1, "hyperedge")) {
                    FileSourceGraphML.this.pushback(e);
                    if (FileSourceGraphML.this.isEvent(e, 1, "data")) {
                        GraphMLConstants.Data data = this.__data();
                        FileSourceGraphML.this.sendGraphAttributeAdded(FileSourceGraphML.this.sourceId, data.key.name, this.getValue(data));
                    } else if (FileSourceGraphML.this.isEvent(e, 1, "node")) {
                        this.__node();
                    } else if (FileSourceGraphML.this.isEvent(e, 1, "edge")) {
                        this.__edge(directed);
                    } else {
                        this.__hyperedge();
                    }
                    e = FileSourceGraphML.this.getNextEvent();
                }
            }
            this.graphId.pop();
            FileSourceGraphML.this.checkValid(e, 2, "graph");
        }

        private void __node() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "node");
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            String id = null;
            HashSet<GraphMLConstants.Key> sentAttributes = new HashSet<GraphMLConstants.Key>();
            HashSet<Attribute> unexpectedAttributes = new HashSet<Attribute>();
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.NodeAttribute attribute = GraphMLConstants.NodeAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case ID: {
                            id = a.getValue();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (FileSourceGraphML.this.strictMode) {
                        FileSourceGraphML.this.newParseError(e, false, "invalid node attribute '%s'", a.getName().getLocalPart());
                    }
                    unexpectedAttributes.add(a);
                }
            }
            if (id == null) {
                FileSourceGraphML.this.newParseError(e, true, "node requires an id", new Object[0]);
            }
            FileSourceGraphML.this.sendNodeAdded(FileSourceGraphML.this.sourceId, id);
            if (!FileSourceGraphML.this.strictMode && unexpectedAttributes.size() > 0) {
                for (Attribute a : unexpectedAttributes) {
                    String name = a.getName().getLocalPart();
                    GraphMLConstants.Key key = this.keys.get(name);
                    String value = key == null ? a.getValue() : this.getValue(key, a.getValue());
                    FileSourceGraphML.this.sendNodeAttributeAdded(FileSourceGraphML.this.sourceId, id, name, value);
                    if (key == null) continue;
                    sentAttributes.add(key);
                }
            }
            if (FileSourceGraphML.this.isEvent(e = FileSourceGraphML.this.getNextEvent(), 1, "desc")) {
                FileSourceGraphML.this.pushback(e);
                String desc = this.__desc();
                FileSourceGraphML.this.sendNodeAttributeAdded(FileSourceGraphML.this.sourceId, id, "desc", desc);
            } else if (FileSourceGraphML.this.isEvent(e, 1, "locator")) {
                FileSourceGraphML.this.pushback(e);
                this.__locator();
            } else {
                while (FileSourceGraphML.this.isEvent(e, 1, "data") || FileSourceGraphML.this.isEvent(e, 1, "port")) {
                    if (FileSourceGraphML.this.isEvent(e, 1, "data")) {
                        FileSourceGraphML.this.pushback(e);
                        GraphMLConstants.Data data = this.__data();
                        FileSourceGraphML.this.sendNodeAttributeAdded(FileSourceGraphML.this.sourceId, id, data.key.name, this.getValue(data));
                        sentAttributes.add(data.key);
                    } else {
                        FileSourceGraphML.this.pushback(e);
                        this.__port();
                    }
                    e = FileSourceGraphML.this.getNextEvent();
                }
            }
            for (GraphMLConstants.Key k : this.keys.values()) {
                if (k.domain != GraphMLConstants.KeyDomain.NODE && k.domain != GraphMLConstants.KeyDomain.ALL || sentAttributes.contains(k)) continue;
                FileSourceGraphML.this.sendNodeAttributeAdded(FileSourceGraphML.this.sourceId, id, k.name, this.getDefaultValue(k));
            }
            if (FileSourceGraphML.this.isEvent(e, 1, "graph")) {
                Location loc = e.getLocation();
                System.err.printf("[WARNING] %d:%d graph inside node is not implemented", loc.getLineNumber(), loc.getColumnNumber());
                FileSourceGraphML.this.pushback(e);
                this.__graph();
                e = FileSourceGraphML.this.getNextEvent();
            }
            FileSourceGraphML.this.checkValid(e, 2, "node");
        }

        private void __edge(boolean edgedefault) throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "edge");
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            HashSet<GraphMLConstants.Key> sentAttributes = new HashSet<GraphMLConstants.Key>();
            HashSet<Attribute> unexpectedAttributes = new HashSet<Attribute>();
            String id = null;
            boolean directed = edgedefault;
            String source = null;
            String target = null;
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.EdgeAttribute attribute = GraphMLConstants.EdgeAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case ID: {
                            id = a.getValue();
                            break;
                        }
                        case DIRECTED: {
                            directed = Boolean.parseBoolean(a.getValue());
                            break;
                        }
                        case SOURCE: {
                            source = a.getValue();
                            break;
                        }
                        case TARGET: {
                            target = a.getValue();
                            break;
                        }
                        case SOURCEPORT: 
                        case TARGETPORT: {
                            FileSourceGraphML.this.newParseError(e, false, "sourceport and targetport not implemented", new Object[0]);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (FileSourceGraphML.this.strictMode) {
                        FileSourceGraphML.this.newParseError(e, false, "invalid graph attribute '%s'", a.getName().getLocalPart());
                    }
                    unexpectedAttributes.add(a);
                }
            }
            if (source == null || target == null) {
                FileSourceGraphML.this.newParseError(e, true, "edge must have a source and a target", new Object[0]);
            }
            if (id == null) {
                id = String.format("%s--%s", source, target);
            }
            FileSourceGraphML.this.sendEdgeAdded(FileSourceGraphML.this.sourceId, id, source, target, directed);
            if (!FileSourceGraphML.this.strictMode && unexpectedAttributes.size() > 0) {
                for (Attribute a : unexpectedAttributes) {
                    String name = a.getName().getLocalPart();
                    GraphMLConstants.Key key = this.keys.get(name);
                    String value = key == null ? a.getValue() : this.getValue(key, a.getValue());
                    FileSourceGraphML.this.sendEdgeAttributeAdded(FileSourceGraphML.this.sourceId, id, name, value);
                    if (key == null) continue;
                    sentAttributes.add(key);
                }
            }
            if (FileSourceGraphML.this.isEvent(e = FileSourceGraphML.this.getNextEvent(), 1, "desc")) {
                FileSourceGraphML.this.pushback(e);
                String desc = this.__desc();
                FileSourceGraphML.this.sendEdgeAttributeAdded(FileSourceGraphML.this.sourceId, id, "desc", desc);
            } else {
                while (FileSourceGraphML.this.isEvent(e, 1, "data")) {
                    FileSourceGraphML.this.pushback(e);
                    GraphMLConstants.Data data = this.__data();
                    FileSourceGraphML.this.sendEdgeAttributeAdded(FileSourceGraphML.this.sourceId, id, data.key.name, this.getValue(data));
                    sentAttributes.add(data.key);
                    e = FileSourceGraphML.this.getNextEvent();
                }
            }
            for (GraphMLConstants.Key k : this.keys.values()) {
                if (k.domain != GraphMLConstants.KeyDomain.EDGE && k.domain != GraphMLConstants.KeyDomain.ALL || sentAttributes.contains(k)) continue;
                FileSourceGraphML.this.sendEdgeAttributeAdded(FileSourceGraphML.this.sourceId, id, k.name, this.getDefaultValue(k));
            }
            if (FileSourceGraphML.this.isEvent(e, 1, "graph")) {
                FileSourceGraphML.this.newParseError(e, false, "graph inside node is not implemented", new Object[0]);
                FileSourceGraphML.this.pushback(e);
                this.__graph();
                e = FileSourceGraphML.this.getNextEvent();
            }
            FileSourceGraphML.this.checkValid(e, 2, "edge");
        }

        private void __hyperedge() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 1, "hyperedge");
            FileSourceGraphML.this.newParseError(e, false, "hyperedge feature is not implemented", new Object[0]);
            String id = null;
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                try {
                    GraphMLConstants.HyperEdgeAttribute attribute = GraphMLConstants.HyperEdgeAttribute.valueOf(FileSourceGraphML.this.toConstantName(a));
                    switch (attribute) {
                        case ID: {
                            id = a.getValue();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    FileSourceGraphML.this.newParseError(e, false, "invalid attribute '%s' for '<endpoint>'", a.getName().getLocalPart());
                }
            }
            if (id == null) {
                FileSourceGraphML.this.newParseError(e, true, "'<hyperedge>' element requires a 'node' attribute", new Object[0]);
            }
            if (FileSourceGraphML.this.isEvent(e = FileSourceGraphML.this.getNextEvent(), 1, "desc")) {
                FileSourceGraphML.this.pushback(e);
                this.__desc();
            } else {
                while (FileSourceGraphML.this.isEvent(e, 1, "data") || FileSourceGraphML.this.isEvent(e, 1, "endpoint")) {
                    if (FileSourceGraphML.this.isEvent(e, 1, "data")) {
                        FileSourceGraphML.this.pushback(e);
                        this.__data();
                    } else {
                        FileSourceGraphML.this.pushback(e);
                        this.__endpoint();
                    }
                    e = FileSourceGraphML.this.getNextEvent();
                }
            }
            if (FileSourceGraphML.this.isEvent(e, 1, "graph")) {
                FileSourceGraphML.this.newParseError(e, false, "graph inside node is not implemented", new Object[0]);
                FileSourceGraphML.this.pushback(e);
                this.__graph();
                e = FileSourceGraphML.this.getNextEvent();
            }
            e = FileSourceGraphML.this.getNextEvent();
            FileSourceGraphML.this.checkValid(e, 2, "hyperedge");
        }
    }

    public static interface GraphMLConstants {

        public static class EndPoint {
            String id = null;
            String node = null;
            String port = null;
            String desc = null;
            EndPointType type = EndPointType.UNDIR;

            EndPoint() {
            }
        }

        public static class Port {
            String name = null;
            String desc = null;
            LinkedList<Data> datas = new LinkedList();
            LinkedList<Port> ports = new LinkedList();

            Port() {
            }
        }

        public static class Locator {
            String href = null;
            String xlink = "http://www.w3.org/TR/2000/PR-xlink-20001220/";
            String type = "simple";

            Locator() {
            }
        }

        public static class Data {
            Key key;
            String id;
            String value;
        }

        public static class Key {
            KeyDomain domain = KeyDomain.ALL;
            String name = null;
            KeyAttrType type = KeyAttrType.STRING;
            String def = null;

            Key() {
            }

            Object getKeyValue(String value) {
                if (value == null) {
                    return null;
                }
                switch (this.type) {
                    case STRING: {
                        return value;
                    }
                    case INT: {
                        return Integer.valueOf(value);
                    }
                    case LONG: {
                        return Long.valueOf(value);
                    }
                    case FLOAT: {
                        return Float.valueOf(value);
                    }
                    case DOUBLE: {
                        return Double.valueOf(value);
                    }
                    case BOOLEAN: {
                        return Boolean.valueOf(value);
                    }
                }
                return value;
            }

            Object getDefaultValue() {
                return this.getKeyValue(this.def);
            }
        }

        public static enum KeyAttrType {
            BOOLEAN,
            INT,
            LONG,
            FLOAT,
            DOUBLE,
            STRING;

        }

        public static enum KeyDomain {
            GRAPHML,
            GRAPH,
            NODE,
            EDGE,
            HYPEREDGE,
            PORT,
            ENDPOINT,
            ALL;

        }

        public static enum KeyAttribute {
            ID,
            FOR,
            ATTR_NAME,
            ATTR_TYPE;

        }

        public static enum HyperEdgeAttribute {
            ID;

        }

        public static enum EndPointType {
            IN,
            OUT,
            UNDIR;

        }

        public static enum EndPointAttribute {
            ID,
            NODE,
            PORT,
            TYPE;

        }

        public static enum PortAttribute {
            NAME;

        }

        public static enum DataAttribute {
            KEY,
            ID;

        }

        public static enum EdgeAttribute {
            ID,
            SOURCE,
            SOURCEPORT,
            TARGET,
            TARGETPORT,
            DIRECTED;

        }

        public static enum NodeAttribute {
            ID;

        }

        public static enum LocatorAttribute {
            XMLNS_XLINK,
            XLINK_HREF,
            XLINK_TYPE;

        }

        public static enum GraphAttribute {
            ID,
            EDGEDEFAULT;

        }

        public static enum Balise {
            GRAPHML,
            GRAPH,
            NODE,
            EDGE,
            HYPEREDGE,
            DESC,
            DATA,
            LOCATOR,
            PORT,
            KEY,
            DEFAULT;

        }
    }
}

