/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.binary;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.graphstream.stream.Pipe;
import org.graphstream.stream.Replayable;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.binary.ByteDecoder;
import org.graphstream.stream.binary.ByteEncoder;
import org.graphstream.stream.binary.ByteFactory;

public class ByteProxy
extends SourceBase
implements Pipe,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(ByteProxy.class.getName());
    protected static final int BUFFER_INITIAL_SIZE = 8192;
    protected final ByteFactory byteFactory;
    protected final ByteEncoder encoder;
    protected final ByteDecoder decoder;
    protected final AtomicBoolean running = new AtomicBoolean(false);
    public final Mode mode;
    public final InetAddress address;
    public final int port;
    protected SelectableChannel mainChannel;
    protected Selector selector;
    protected Thread thread = null;
    protected Collection<SocketChannel> writableChannels = new LinkedList<SocketChannel>();
    protected Replayable replayable = null;

    public ByteProxy(ByteFactory factory, int port) throws IOException {
        this(factory, Mode.SERVER, InetAddress.getLocalHost(), port);
    }

    public ByteProxy(ByteFactory factory, Mode mode, InetAddress address, int port) throws IOException {
        this.mode = mode;
        this.address = address;
        this.port = port;
        this.byteFactory = factory;
        this.encoder = factory.createByteEncoder();
        this.decoder = factory.createByteDecoder();
        this.encoder.addTransport(new ByteEncoder.Transport(){

            @Override
            public void send(ByteBuffer buffer) {
                ByteProxy.this.doSend(buffer);
            }
        });
        this.decoder.addSink(new Sink(){

            @Override
            public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
                ByteProxy.this.sendGraphAttributeAdded(sourceId, timeId, attribute, value);
            }

            @Override
            public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
                ByteProxy.this.sendGraphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
            }

            @Override
            public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
                ByteProxy.this.sendGraphAttributeRemoved(sourceId, timeId, attribute);
            }

            @Override
            public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
                ByteProxy.this.sendNodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
            }

            @Override
            public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
                ByteProxy.this.sendNodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
            }

            @Override
            public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
                ByteProxy.this.sendNodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
            }

            @Override
            public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
                ByteProxy.this.sendEdgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
            }

            @Override
            public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
                ByteProxy.this.sendEdgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
            }

            @Override
            public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
                ByteProxy.this.sendEdgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
            }

            @Override
            public void nodeAdded(String sourceId, long timeId, String nodeId) {
                ByteProxy.this.sendNodeAdded(sourceId, timeId, nodeId);
            }

            @Override
            public void nodeRemoved(String sourceId, long timeId, String nodeId) {
                ByteProxy.this.sendNodeRemoved(sourceId, timeId, nodeId);
            }

            @Override
            public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
                ByteProxy.this.sendEdgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
            }

            @Override
            public void edgeRemoved(String sourceId, long timeId, String edgeId) {
                ByteProxy.this.sendEdgeRemoved(sourceId, timeId, edgeId);
            }

            @Override
            public void graphCleared(String sourceId, long timeId) {
                ByteProxy.this.sendGraphCleared(sourceId, timeId);
            }

            @Override
            public void stepBegins(String sourceId, long timeId, double step) {
                ByteProxy.this.sendStepBegins(sourceId, timeId, step);
            }
        });
        this.init();
    }

    protected void init() throws IOException {
        InetSocketAddress isa = new InetSocketAddress(this.address, this.port);
        this.selector = Selector.open();
        switch (this.mode) {
            case SERVER: {
                ServerSocketChannel serverChannel = ServerSocketChannel.open();
                serverChannel.configureBlocking(false);
                serverChannel.bind(isa);
                this.mainChannel = serverChannel;
                this.mainChannel.register(this.selector, 16);
                break;
            }
            case CLIENT: {
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.connect(isa);
                socketChannel.finishConnect();
                socketChannel.configureBlocking(false);
                this.mainChannel = socketChannel;
                this.mainChannel.register(this.selector, 5);
                this.writableChannels.add(socketChannel);
            }
        }
    }

    public void setReplayable(Replayable replayable) {
        this.replayable = replayable;
    }

    public synchronized void start() {
        if (this.thread != null) {
            LOGGER.warning("Already started.");
        } else {
            Thread t = new Thread(this);
            t.start();
        }
    }

    public void stop() throws InterruptedException {
        if (this.thread != null) {
            Thread t = this.thread;
            this.running.set(false);
            t.join();
        }
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        this.running.set(true);
        LOGGER.info(String.format("[%s] started on %s:%d...", new Object[]{this.mode, this.address.getHostName(), this.port}));
        while (this.running.get()) {
            this.poll();
        }
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSelectedKeys() throws IOException {
        Set<SelectionKey> readyKeys = this.selector.selectedKeys();
        Iterator<SelectionKey> i = readyKeys.iterator();
        while (i.hasNext()) {
            SelectionKey key = i.next();
            i.remove();
            if (key.isAcceptable()) {
                assert (this.mode == Mode.SERVER);
                ServerSocketChannel ssocket = (ServerSocketChannel)key.channel();
                SocketChannel socketChannel = ssocket.accept();
                LOGGER.info(String.format("accepting socket %s:%d", socketChannel.socket().getInetAddress(), socketChannel.socket().getPort()));
                socketChannel.finishConnect();
                socketChannel.configureBlocking(false);
                if (this.decoder != null) {
                    socketChannel.register(this.selector, 1);
                }
                this.replay(socketChannel);
                this.writableChannels.add(socketChannel);
                continue;
            }
            if (key.isReadable()) {
                this.readDataChunk(key);
                continue;
            }
            if (!key.isWritable() || key.attachment() == null) continue;
            ByteBuffer buffer = (ByteBuffer)key.attachment();
            WritableByteChannel out = (WritableByteChannel)((Object)key.channel());
            try {
                out.write(buffer);
            }
            catch (IOException e) {
                LOGGER.severe("I/O error while writing to channel.");
                this.close(out);
            }
            finally {
                key.cancel();
            }
        }
    }

    public void poll() {
        this.poll(true);
    }

    public void poll(boolean blocking) {
        try {
            if (blocking) {
                if (this.selector.select() > 0) {
                    this.processSelectedKeys();
                }
            } else if (this.selector.selectNow() > 0) {
                this.processSelectedKeys();
            }
        }
        catch (IOException e) {
            LOGGER.severe(String.format("I/O error in receiver //:%d thread: aborting: %s", this.port, e.getMessage()));
            this.running.set(false);
        }
        catch (Throwable e) {
            LOGGER.severe(String.format("Unknown error: %s", e.getMessage()));
            e.printStackTrace();
            this.running.set(false);
        }
    }

    protected void readDataChunk(SelectionKey key) throws IOException {
        ByteBuffer buffer = (ByteBuffer)key.attachment();
        SocketChannel socket = (SocketChannel)key.channel();
        if (buffer == null) {
            buffer = ByteBuffer.allocate(8192);
            key.attach(buffer);
            LOGGER.info(String.format("creating buffer for new connection from %s:%d", socket.socket().getInetAddress(), socket.socket().getPort()));
        }
        try {
            int r = socket.read(buffer);
            if (r < 0) {
                LOGGER.info("end-of-stream reached. Closing the mainChannel.");
                this.close(socket);
            } else if (r == 0) {
                LOGGER.warning("Strange, no binary read.");
            } else {
                while (this.decoder.validate(buffer)) {
                    buffer.flip();
                    this.decoder.decode(buffer);
                    buffer.compact();
                }
                if (!buffer.hasRemaining()) {
                    ByteBuffer bigger = ByteBuffer.allocate(buffer.capacity() + 8192);
                    bigger.put(buffer);
                    key.attach(bigger);
                }
            }
        }
        catch (IOException e) {
            LOGGER.severe(String.format("receiver //%s:%d cannot read object socket mainChannel (I/O error): %s", this.address.getHostName(), this.port, e.getMessage()));
            this.close(key.channel());
        }
    }

    protected void doSend(ByteBuffer buffer) {
        ByteBuffer sendBuffer = ByteBuffer.allocate(buffer.remaining());
        sendBuffer.put(buffer);
        sendBuffer.rewind();
        Iterator<SocketChannel> channels = this.writableChannels.iterator();
        while (channels.hasNext()) {
            SocketChannel writableChannel = channels.next();
            try {
                try {
                    writableChannel.write(sendBuffer.duplicate());
                }
                catch (NotYetConnectedException e) {
                    writableChannel.register(this.selector, 4, sendBuffer.duplicate());
                }
            }
            catch (IOException e) {
                LOGGER.severe("I/O error while writing to channel : " + e.getMessage());
                channels.remove();
                this.close(writableChannel);
            }
        }
    }

    protected void replay(final SocketChannel channel) {
        if (this.replayable != null) {
            final Replayable.Controller controller = this.replayable.getReplayController();
            final ByteEncoder encoder = this.byteFactory.createByteEncoder();
            encoder.addTransport(new ByteEncoder.Transport(){

                @Override
                public void send(ByteBuffer buffer) {
                    try {
                        channel.write(buffer);
                    }
                    catch (IOException e) {
                        LOGGER.severe("Failled to replay : " + e.getMessage());
                        controller.removeSink(encoder);
                    }
                }
            });
            controller.addSink(encoder);
            controller.replay();
        }
    }

    protected void close(Channel channel) {
        this.writableChannels.remove(channel);
        if (channel == this.mainChannel) {
            LOGGER.warning("Closing main channel.");
            if (this.running.get()) {
                try {
                    this.stop();
                }
                catch (InterruptedException e) {
                    LOGGER.warning("Failed to properly terminate the worker.");
                }
            }
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            LOGGER.warning("closing channel: " + e.getMessage());
        }
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.encoder.graphAttributeAdded(sourceId, timeId, attribute, value);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.encoder.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.encoder.graphAttributeRemoved(sourceId, timeId, attribute);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.encoder.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.encoder.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.encoder.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.encoder.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.encoder.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.encoder.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.encoder.nodeAdded(sourceId, timeId, nodeId);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.encoder.nodeRemoved(sourceId, timeId, nodeId);
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.encoder.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.encoder.edgeRemoved(sourceId, timeId, edgeId);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.encoder.graphCleared(sourceId, timeId);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.encoder.stepBegins(sourceId, timeId, step);
    }

    public static enum Mode {
        SERVER,
        CLIENT;

    }
}

