set terminal pngcairo size 1400,1600
set output "target/courbes/propagation_compare_reseaux_3scenarios.png"

set grid
set key top right
set xlabel "Jour"
set ylabel "Fraction d'infectés (non immunisés)"
set yrange [0:1]

set multiplot layout 3,1 title "Comparaison réseaux (DBLP / Aleatoire / BA) - 3 scénarios"

# 1) Scenario RIEN
set title "Scénario : RIEN"
plot \
  "target/dat/dblp_rien_moyenne.dat" using 1:2 with lines lw 2 title "DBLP", \
  "target/dat/aleatoire_rien_moyenne.dat" using 1:2 with lines lw 2 title "Aléatoire", \
  "target/dat/ba_rien_moyenne.dat" using 1:2 with lines lw 2 title "Barabasi-Albert"

# 2) Scenario IMMUN_ALEA_50
set title "Scénario : Immunisation aléatoire 50%"
plot \
  "target/dat/dblp_immun_alea_50_moyenne.dat" using 1:2 with lines lw 2 title "DBLP", \
  "target/dat/aleatoire_immun_alea_50_moyenne.dat" using 1:2 with lines lw 2 title "Aléatoire", \
  "target/dat/ba_immun_alea_50_moyenne.dat" using 1:2 with lines lw 2 title "Barabasi-Albert"

# 3) Scenario IMMUN_SELECTIVE
set title "Scénario : Immunisation sélective"
set yrange [0:0.001]
plot \
  "target/dat/dblp_immun_selective_moyenne.dat" using 1:2 with lines lw 2 title "DBLP", \
  "target/dat/aleatoire_immun_selective_moyenne.dat" using 1:2 with lines lw 2 title "Aléatoire", \
  "target/dat/ba_immun_selective_moyenne.dat" using 1:2 with lines lw 2 title "Barabasi-Albert"

unset multiplot