# Comparaison distributions des distances : DBLP vs ER vs BA
# Fichiers attendus :
#   target/dat/distrib_distances_reel.dat
#   target/dat/distrib_distances_Aleatoire.dat
#   target/dat/distrib_distances_AP.dat
# Format: d p(d)

set terminal pngcairo size 1200,900 enhanced
set output "target/courbes/distances_compare.png"

set title "Distribution des distances - comparaison DBLP vs ER vs BA"
set xlabel "distance d"
set ylabel "p(d)"
set grid

# optionnel : si tu veux zoomer comme ta figure
set xrange [0:25]
set yrange [0:*]

plot \
  "target/dat/distrib_distances_reel.dat"      using 1:2 with linespoints title "DBLP", \
  "target/dat/distrib_distances_Aleatoire.dat" using 1:2 with linespoints title "ER (aléatoire)", \
  "target/dat/distrib_distances_AP.dat"        using 1:2 with linespoints title "BA (préférentiel)"
