# degree_reel_loglog_fit.gnuplot
set term pngcairo size 1200,900 enhanced
set output "target/courbes/degree_reel_loglog_fit.png"

set title "DBLP - distribution des degres (log-log) + Poisson + fit loi de puissance"
set xlabel "k"
set ylabel "p(k)"
set grid
set logscale xy
set xrange [1:1000]
set yrange [1e-6:1]
set key right top

file = "target/dat/distrib_degrees_reel.dat"

# moyenne (ton <k>)
lambda = 6.62208890914917
poisson(x) = (lambda**x) * exp(-lambda) / gamma(x+1)

# Fit loi de puissance sur la QUEUE uniquement
kmin = 10
c = 1
gammaP = 2.5
power(x) = c * x**(-gammaP)

fit power(x) file using (($1>=kmin) ? $1 : 1/0):2 via c, gammaP

plot \
  file using 1:2 with points pt 2 ps 0.7 title "DBLP", \
  poisson(x) with lines title "Poisson (meme <k>)", \
  power(x) with lines title sprintf("Power-law fit (k>=%d, gamma=%.2f)", kmin, gammaP)
