# Comparaison distributions des degrés (log-log) : DBLP vs ER vs BA
# Fichiers attendus :
#   target/dat/distrib_degrees_reel.dat
#   target/dat/distrib_degrees_Aleatoire.dat
#   target/dat/distrib_degrees_AP.dat

set terminal pngcairo size 1200,900 enhanced
set output "target/courbes/degree_compare_loglog.png"

set title "Distribution des degrés (log-log) - DBLP vs ER vs BA"
set xlabel "k"
set ylabel "p(k)"
set grid

set logscale xy
set xrange [1:*]
set yrange [1e-6:1]

plot \
  "target/dat/distrib_degrees_reel.dat"      using 1:2 with points pointtype 2 title "DBLP", \
  "target/dat/distrib_degrees_Aleatoire.dat" using 1:2 with points pointtype 6 title "ER", \
  "target/dat/distrib_degrees_AP.dat"        using 1:2 with points pointtype 4 title "BA"
