import java.io.IOException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.file.FileSourceEdge;
import org.graphstream.algorithm.Toolkit;

public class App {
    public static void main(String[] args) throws IOException{
        String filePath = "com-dblp.ungraph.txt";
		Graph g = new SingleGraph("g");
        FileSourceEdge fse = new FileSourceEdge();
        
		fse.addSink(g);
        System.out.println("Flag 1");
		try {
			fse.readAll(filePath);

			/*while (fse.nextEvents()) {
				// Optionally some code here ...
			}*/
		} catch( IOException e) {
			e.printStackTrace();
		}

        int N = g.getNodeCount();
        int L = g.getEdgeCount();
        double p = 1.0/N;
        double k = Toolkit.averageDegree(g);
        double C = Toolkit.averageClusteringCoefficient(g);

        System.out.println("Noeuds : " + g.getNodeCount()); // N
        System.out.println("Arêtes : " + g.getEdgeCount()); // L
        System.out.println("Degré moyen : " + k); // <k> = 2L/N
        System.out.println("Coefficient de clustering moyen : " + C); // <C>

        System.out.println("p = " + p);
        System.out.println("p > ln N / N : " + (p > Math.log(N)/N));
        System.out.println("<k> > ln N : " + ( k > Math.log(N)));
        System.out.println("Pour qu'il soit connexe, il faut <k> > " + Math.log(N));
    }
}