/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.tlp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSourceTLP;
import org.graphstream.stream.file.tlp.TLPParserConstants;
import org.graphstream.stream.file.tlp.TLPParserTokenManager;
import org.graphstream.util.parser.ParseException;
import org.graphstream.util.parser.Parser;
import org.graphstream.util.parser.SimpleCharStream;
import org.graphstream.util.parser.Token;

public class TLPParser
implements Parser,
TLPParserConstants {
    private FileSourceTLP tlp;
    private String sourceId;
    private Cluster root;
    private HashMap<Integer, Cluster> clusters;
    private Stack<Cluster> stack;
    public TLPParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[8];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[5];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public TLPParser(FileSourceTLP tlp, InputStream stream) {
        this(stream);
        this.init(tlp);
    }

    public TLPParser(FileSourceTLP tlp, Reader stream) {
        this(stream);
        this.init(tlp);
    }

    @Override
    public void close() throws IOException {
        this.jj_input_stream.close();
        this.clusters.clear();
    }

    private void init(FileSourceTLP tlp) {
        this.tlp = tlp;
        this.sourceId = String.format("<DOT stream %x>", System.nanoTime());
        this.clusters = new HashMap();
        this.stack = new Stack();
        this.root = new Cluster(0, "<root>");
        this.clusters.put(0, this.root);
        this.stack.push(this.root);
    }

    private void addNode(String id) throws ParseException {
        if (!(this.stack.size() <= 1 || this.root.nodes.contains(id) && ((Cluster)this.stack.get((int)(this.stack.size() - 2))).nodes.contains(id))) {
            throw new ParseException("parent cluster do not contain the node");
        }
        if (this.stack.size() == 1) {
            this.tlp.sendNodeAdded(this.sourceId, id);
        }
        this.stack.peek().nodes.add(id);
    }

    private void addEdge(String id, String source, String target) throws ParseException {
        if (!(this.stack.size() <= 1 || this.root.edges.contains(id) && ((Cluster)this.stack.get((int)(this.stack.size() - 2))).edges.contains(id))) {
            throw new ParseException("parent cluster " + ((Cluster)this.stack.get((int)(this.stack.size() - 2))).name + " do not contain the edge");
        }
        if (this.stack.size() == 1) {
            this.tlp.sendEdgeAdded(this.sourceId, id, source, target, false);
        }
        this.stack.peek().edges.add(id);
    }

    private void includeEdge(String id) throws ParseException {
        if (!(this.stack.size() <= 1 || this.root.edges.contains(id) && ((Cluster)this.stack.get((int)(this.stack.size() - 2))).edges.contains(id))) {
            throw new ParseException("parent cluster " + ((Cluster)this.stack.get((int)(this.stack.size() - 2))).name + " do not contain the edge");
        }
        this.stack.peek().edges.add(id);
    }

    private void graphAttribute(String key, Object value) {
        this.tlp.sendAttributeChangedEvent(this.sourceId, this.sourceId, SourceBase.ElementType.GRAPH, key, AbstractElement.AttributeChangeEvent.ADD, null, value);
    }

    private void pushCluster(int i, String name) {
        Cluster c = new Cluster(i, name);
        this.clusters.put(i, c);
        this.stack.push(c);
    }

    private void popCluster() {
        if (this.stack.size() > 1) {
            this.stack.pop();
        }
    }

    private void newProperty(Integer cluster, String name, PropertyType type, String nodeDefault, String edgeDefault, HashMap<String, String> nodes, HashMap<String, String> edges) {
        Object value;
        Object nodeDefaultValue = this.convert(type, nodeDefault);
        Object edgeDefaultValue = this.convert(type, edgeDefault);
        Cluster c = this.clusters.get(cluster);
        for (String id : c.nodes) {
            value = nodeDefaultValue;
            if (nodes.containsKey(id)) {
                value = this.convert(type, nodes.get(id));
            }
            this.tlp.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.NODE, name, AbstractElement.AttributeChangeEvent.ADD, null, value);
        }
        for (String id : c.edges) {
            value = edgeDefaultValue;
            if (edges.containsKey(id)) {
                value = this.convert(type, edges.get(id));
            }
            this.tlp.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.EDGE, name, AbstractElement.AttributeChangeEvent.ADD, null, value);
        }
    }

    private Object convert(PropertyType type, String value) {
        switch (type) {
            case BOOL: {
                return Boolean.valueOf(value);
            }
            case INT: {
                return Integer.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
            case LAYOUT: 
            case COLOR: 
            case SIZE: 
            case STRING: {
                return value;
            }
        }
        return value;
    }

    @Override
    public final void all() throws ParseException {
        this.tlp();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.statement();
        }
        this.jj_consume_token(11);
        this.jj_consume_token(0);
    }

    @Override
    public final boolean next() throws ParseException {
        boolean hasMore = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.statement();
                hasMore = true;
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return hasMore;
    }

    @Override
    public final void open() throws ParseException {
        this.tlp();
    }

    private final void tlp() throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(12);
        this.jj_consume_token(26);
        while (this.jj_2_1(2)) {
            this.headers();
        }
    }

    private final void headers() throws ParseException {
        this.jj_consume_token(10);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                String s = this.string();
                this.graphAttribute("date", s);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                String s = this.string();
                this.graphAttribute("author", s);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                String s = this.string();
                this.graphAttribute("comments", s);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(11);
    }

    private final void statement() throws ParseException {
        if (this.jj_2_2(2)) {
            this.nodes();
        } else if (this.jj_2_3(2)) {
            this.edge();
        } else if (this.jj_2_4(2)) {
            this.cluster();
        } else if (this.jj_2_5(2)) {
            this.property();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private final void nodes() throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(15);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            Token i = this.jj_consume_token(24);
            this.addNode(i.image);
        }
        this.jj_consume_token(11);
    }

    private final void edge() throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(16);
        Token i = this.jj_consume_token(24);
        Token s = this.jj_consume_token(24);
        Token t = this.jj_consume_token(24);
        this.jj_consume_token(11);
        this.addEdge(i.image, s.image, t.image);
    }

    private final void edges() throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(17);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            Token i = this.jj_consume_token(24);
            this.includeEdge(i.image);
        }
        this.jj_consume_token(11);
    }

    private final void cluster() throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(18);
        Token index = this.jj_consume_token(24);
        String name = this.string();
        this.pushCluster(Integer.valueOf(index.image), name);
        this.nodes();
        this.edges();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.cluster();
        }
        this.jj_consume_token(11);
        this.popCluster();
    }

    private final void property() throws ParseException {
        HashMap<String, String> nodes = new HashMap<String, String>();
        HashMap<String, String> edges = new HashMap<String, String>();
        this.jj_consume_token(10);
        this.jj_consume_token(22);
        Integer cluster = this.integer();
        PropertyType type = this.type();
        String name = this.string();
        this.jj_consume_token(10);
        this.jj_consume_token(23);
        String nodeDefault = this.string();
        String edgeDefault = this.string();
        this.jj_consume_token(11);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(10);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    this.jj_consume_token(14);
                    Token t = this.jj_consume_token(24);
                    String value = this.string();
                    nodes.put(t.image, value);
                    break;
                }
                case 16: {
                    this.jj_consume_token(16);
                    Token t = this.jj_consume_token(24);
                    String value = this.string();
                    edges.put(t.image, value);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(11);
        }
        this.jj_consume_token(11);
        this.newProperty(cluster, name, type, nodeDefault, edgeDefault, nodes, edges);
    }

    private final PropertyType type() throws ParseException {
        Token t = this.jj_consume_token(27);
        return PropertyType.valueOf(t.image.toUpperCase());
    }

    private final String string() throws ParseException {
        Token t = this.jj_consume_token(26);
        return t.image.substring(1, t.image.length() - 1);
    }

    private final Integer integer() throws ParseException {
        Token t = this.jj_consume_token(24);
        return Integer.valueOf(t.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    private boolean jj_3_1() {
        return this.jj_3R_7();
    }

    private boolean jj_3_5() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(16);
    }

    private boolean jj_3_4() {
        return this.jj_3R_10();
    }

    private boolean jj_3_3() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3_2() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_11() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_10() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_7() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_13()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_14()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_8() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1024, 1025, 0x380000, 0x1000000, 0x1000000, 1024, 1024, 81920};
    }

    public TLPParser(InputStream stream) {
        this(stream, null);
    }

    public TLPParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TLPParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TLPParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new TLPParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TLPParser(TLPParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(TLPParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[28];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 8; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 28; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 5; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        TLPParser.jj_la1_init_0();
    }

    protected static class Cluster {
        int index;
        String name;
        LinkedList<String> nodes;
        LinkedList<String> edges;

        Cluster(int index, String name) {
            this.index = index;
            this.name = name;
            this.nodes = new LinkedList();
            this.edges = new LinkedList();
        }
    }

    protected static enum PropertyType {
        BOOL,
        COLOR,
        DOUBLE,
        LAYOUT,
        INT,
        SIZE,
        STRING;

    }

    private static final class LookaheadSuccess
    extends Error {
        private static final long serialVersionUID = -7986896058452164869L;

        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

