/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.graph.implementations.AbstractNode;

public class AdjacencyListNode
extends AbstractNode {
    protected static final int INITIAL_EDGE_CAPACITY;
    protected static final double GROWTH_FACTOR = 1.1;
    protected static final char I_EDGE = '\u0000';
    protected static final char IO_EDGE = '\u0001';
    protected static final char O_EDGE = '\u0002';
    protected AbstractEdge[] edges = new AbstractEdge[INITIAL_EDGE_CAPACITY];
    protected int ioStart = 0;
    protected int oStart = 0;
    protected int degree = 0;

    protected AdjacencyListNode(AbstractGraph graph, String id) {
        super(graph, id);
    }

    protected char edgeType(AbstractEdge e) {
        if (!e.directed || e.source == e.target) {
            return '\u0001';
        }
        return e.source == this ? (char)'\u0002' : '\u0000';
    }

    protected <T extends Edge> T locateEdge(Node opposite, char type) {
        int start = 0;
        int end = this.degree;
        if (type == '\u0000') {
            end = this.oStart;
        } else if (type == '\u0002') {
            start = this.ioStart;
        }
        for (int i = start; i < end; ++i) {
            if (this.edges[i].getOpposite(this) != opposite) continue;
            return (T)this.edges[i];
        }
        return null;
    }

    protected void removeEdge(int i) {
        if (i >= this.oStart) {
            this.edges[i] = this.edges[--this.degree];
            this.edges[this.degree] = null;
            return;
        }
        if (i >= this.ioStart) {
            this.edges[i] = this.edges[--this.oStart];
            this.edges[this.oStart] = this.edges[--this.degree];
            this.edges[this.degree] = null;
            return;
        }
        this.edges[i] = this.edges[--this.ioStart];
        this.edges[this.ioStart] = this.edges[--this.oStart];
        this.edges[this.oStart] = this.edges[--this.degree];
        this.edges[this.degree] = null;
    }

    @Override
    protected boolean addEdgeCallback(AbstractEdge edge) {
        char type;
        if (this.edges.length == this.degree) {
            AbstractEdge[] tmp = new AbstractEdge[(int)(1.1 * (double)this.edges.length) + 1];
            System.arraycopy(this.edges, 0, tmp, 0, this.edges.length);
            Arrays.fill(this.edges, null);
            this.edges = tmp;
        }
        if ((type = this.edgeType(edge)) == '\u0002') {
            this.edges[this.degree++] = edge;
            return true;
        }
        if (type == '\u0001') {
            this.edges[this.degree++] = this.edges[this.oStart];
            this.edges[this.oStart++] = edge;
            return true;
        }
        this.edges[this.degree++] = this.edges[this.oStart];
        this.edges[this.oStart++] = this.edges[this.ioStart];
        this.edges[this.ioStart++] = edge;
        return true;
    }

    @Override
    protected void removeEdgeCallback(AbstractEdge edge) {
        char type = this.edgeType(edge);
        int i = 0;
        if (type == '\u0001') {
            i = this.ioStart;
        } else if (type == '\u0002') {
            i = this.oStart;
        }
        while (this.edges[i] != edge) {
            ++i;
        }
        this.removeEdge(i);
    }

    @Override
    protected void clearCallback() {
        Arrays.fill(this.edges, 0, this.degree, null);
        this.degree = 0;
        this.oStart = 0;
        this.ioStart = 0;
    }

    @Override
    public int getDegree() {
        return this.degree;
    }

    @Override
    public int getInDegree() {
        return this.oStart;
    }

    @Override
    public int getOutDegree() {
        return this.degree - this.ioStart;
    }

    @Override
    public Edge getEdge(int i) {
        if (i < 0 || i >= this.degree) {
            throw new IndexOutOfBoundsException("Node \"" + this + "\" has no edge " + i);
        }
        return this.edges[i];
    }

    @Override
    public Edge getEnteringEdge(int i) {
        if (i < 0 || i >= this.getInDegree()) {
            throw new IndexOutOfBoundsException("Node \"" + this + "\" has no entering edge " + i);
        }
        return this.edges[i];
    }

    @Override
    public Edge getLeavingEdge(int i) {
        if (i < 0 || i >= this.getOutDegree()) {
            throw new IndexOutOfBoundsException("Node \"" + this + "\" has no edge " + i);
        }
        return this.edges[this.ioStart + i];
    }

    @Override
    public Edge getEdgeBetween(Node node) {
        return this.locateEdge(node, '\u0001');
    }

    @Override
    public Edge getEdgeFrom(Node node) {
        return this.locateEdge(node, '\u0000');
    }

    @Override
    public Edge getEdgeToward(Node node) {
        return this.locateEdge(node, '\u0002');
    }

    @Override
    public Stream<Edge> edges() {
        return Arrays.stream(this.edges, 0, this.degree);
    }

    @Override
    public Stream<Edge> enteringEdges() {
        return Arrays.stream(this.edges, 0, this.oStart);
    }

    @Override
    public Stream<Edge> leavingEdges() {
        return Arrays.stream(this.edges, this.ioStart, this.degree);
    }

    static {
        String p = "org.graphstream.graph.node.initialEdgeCapacity";
        int initialEdgeCapacity = 16;
        try {
            initialEdgeCapacity = Integer.valueOf(System.getProperty(p, "16"));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        INITIAL_EDGE_CAPACITY = initialEdgeCapacity;
    }

    protected class EdgeIterator<T extends Edge>
    implements Iterator<T> {
        protected int iPrev = -1;
        protected int iNext = 0;
        protected int iEnd;

        protected EdgeIterator(char type) {
            this.iEnd = AdjacencyListNode.this.degree;
            if (type == '\u0000') {
                this.iEnd = AdjacencyListNode.this.oStart;
            } else if (type == '\u0002') {
                this.iNext = AdjacencyListNode.this.ioStart;
            }
        }

        @Override
        public boolean hasNext() {
            return this.iNext < this.iEnd;
        }

        @Override
        public T next() {
            if (this.iNext >= this.iEnd) {
                throw new NoSuchElementException();
            }
            this.iPrev = this.iNext++;
            return (T)AdjacencyListNode.this.edges[this.iPrev];
        }

        @Override
        public void remove() {
            if (this.iPrev == -1) {
                throw new IllegalStateException();
            }
            AbstractEdge e = AdjacencyListNode.this.edges[this.iPrev];
            AdjacencyListNode.this.graph.removeEdge(e, true, e.source != AdjacencyListNode.this, e.target != AdjacencyListNode.this);
            AdjacencyListNode.this.removeEdge(this.iPrev);
            this.iNext = this.iPrev;
            this.iPrev = -1;
            --this.iEnd;
        }
    }
}

