<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use App\Controller\SaleController;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\GetCollection;
use App\Controller\ChartController;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/api/bar-chart/{startDate}/{endDate}/{granularity}',
            requirements: [
                'startDate' => '\d{4}-\d{2}-\d{2}',
                'endDate' => '\d{4}-\d{2}-\d{2}',
                'granularity' => 'day|month|year',
            ],
            controller: ChartController::class,
            name: 'bar-chart'
        ),
        new GetCollection(
            uriTemplate: '/api/donut-chart/{id}',
            requirements: [
                'id' => '\d{4}',
            ],
            controller: ChartController::class,
            name: 'donut-chart',
        ),
    ]
)]


#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/sales/monthly_average_price_evolution',
            controller: SaleController::class,
            name: 'monthly_average_price_evolution'
        )
    ]
)]

/** A sale. */
#[ORM\Entity]
class Sale
{

    /** The id of this sale. **/
    #[ORM\Id, ORM\Column, ORM\GeneratedValue]
    private ?int $id;

    /** The date of this sale. */
    #[ORM\Column]
    private ?\DateTimeImmutable $date;

    /** The amount of this sale. */
    #[ORM\Column]
    private ?float $amount;

    /** The surface of this sale. */
    #[ORM\Column]
    private ?float $surface;

    /** The region of this sale. */
    #[ORM\Column()]
    private ?string $region;


    // constructor
    public function __construct(
        \DateTimeImmutable $date = null,
        float $amount = null,
        float $surface = null,
        string $region = null
    ) {
        $this->date = $date;
        $this->amount = $amount;
        $this->surface = $surface;
        $this->region = $region;
    }

    // getters
    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDate(): ?\DateTimeInterface
    {
        return $this->date;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function getSurface(): ?float
    {
        return $this->surface;
    }

    public function getRegion(): ?string
    {
        return $this->region;
    }

    // setters
    public function setDate(\DateTimeImmutable $date): void
    {
        $this->date = $date;
    }

    public function setAmount(float $amount): void
    {
        $this->amount = $amount;
    }

    public function setSurface(float $surface): void
    {
        $this->surface = $surface;
    }

    public function setRegion(string $region): void
    {
        $this->region = $region;
    }
}
