<?php

namespace App\Controller;

use ApiPlatform\Metadata\Get;
use App\Service\SaleService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Attribute\AsController;
use Symfony\Component\Routing\Annotation\Route;

#[AsController]
class SaleController extends AbstractController
{
    private SaleService $saleService;

    public function __construct(SaleService $saleService)
    {
        $this->saleService = $saleService;
    }

    public function __invoke(): JsonResponse
    {
        $result = $this->saleService->getMonthlyAveragePriceEvolution();

        return $this->json($result);
    }
}
