/**
  * @param {number} year
  */
async function getDonutContent(year) {
  return new Promise((resolve, reject) => {
    resolve(
      [
        "Auvergne-Rhône-Alpes",
        "Hauts-de-France",
        "Provence-Alpes-Côte d'Azur",
        "Grand Est",
        "Occitanie",
        "Normandie",
        "Nouvelle-Aquitaine",
        "Centre-Val de Loire",
        "Corse",
        "Bourgogne-Franche-Comté",
        "Bretagne",
        "Pays de la Loire",
        "Île-de-France",
        "Guadeloupe",
        "Martinique",
        "Guyane",
        "La Réunion",
        "Mayotte",
        "Nouvelle Calédonie"
      ].map((x) => ({region: x, occurences: Math.round(Math.random() * 300)}))
    );
  });
}

export default {
  getDonutContent
};
