# API

The API will be here.

Refer to the [Getting Started Guide](https://api-platform.com/docs/distribution) for more information.

## Migrations and database
To manage migrations and update the database, follow these steps:

1. Generate a new migration:

    ```bash
    docker compose exec php bin/console doctrine:migrations:diff
    ```

2. Modify the generated migration file:
   Open the generated migration file in `api/migrations` and locate the `id` column for the `Sale` entity. Replace the line:

    ```php
    $this->addSql('CREATE TABLE sale (id INT NOT NULL, ...)');
    ```

   with:

    ```php
    $this->addSql('CREATE TABLE sale (id INT NOT NULL DEFAULT nextval(\'sale_id_seq\'::regclass), ...)');
    ```

3. Apply the migration:

    ```bash
    docker compose exec php bin/console doctrine:migrations:migrate
    ```

(Optimisation)
Indexation de la Colonne de Date, car toutes les routes font des opérations de filtrage basées sur cette colonne.
````sql
create index date_index on sale (date);
````

