import React, {useState} from 'react';
import constants from '../../../config.js';

function YearInput({ onDateChange }) {
    const [selectedYear, setSelectedYear] = useState(`${constants.initialDonutChartYear.selectedYear}`);

    const handleYearChange = (event) => {
        setSelectedYear(event.target.value);
    };

    const handleButtonClick = () => {
        onDateChange(selectedYear);
    };

    return (
        <div className="form-container">
            <select
                value={selectedYear}
                onChange={handleYearChange}
            >
                {Array.from({ length: 5 }, (_, index) => 2018 + index).map((year) => (
                    <option key={year} value={year}>
                        {year}
                    </option>
                ))}
            </select>
            <button onClick={handleButtonClick}>Afficher</button>
        </div>
    );
}

export default YearInput;
