import React, { useState } from 'react';
import '../../style/style.css';
import constants from '../../../config.js';

const DataForm = ({ onSubmit }) => {
    const [startDate, setStartDate] = useState(`${constants.initialBarChartFormData.startDate}`);
    const [endDate, setEndDate] = useState(`${constants.initialBarChartFormData.endDate}`);
    const [granularity, setGranularity] = useState(`${constants.initialBarChartFormData.granularity}`);

    const handleSubmit = (event) => {
        event.preventDefault();

        if (startDate === endDate) {
            alert("La date de début ne doit pas être égale à la date de fin.");
            return;
        }
        if (startDate > endDate) {
            alert("La date de début ne doit pas être supérieure à la date de fin.");
            return;
        }

        onSubmit({ startDate, endDate, granularity });
    };

    return (
        <form onSubmit={handleSubmit} className="form-container">
            <input
                type="date"
                value={startDate}
                onChange={(e) => setStartDate(e.target.value)}
                required
            />
            <input
                type="date"
                value={endDate}
                onChange={(e) => setEndDate(e.target.value)}
                required
            />
            <select
                value={granularity}
                onChange={(e) => setGranularity(e.target.value)}
            >
                <option value="day">Jour</option>
                <option value="month">Mois</option>
                <option value="year">Année</option>
            </select>
            <button type="submit">Afficher</button>
        </form>
    );
};

export default DataForm;
