# API

The API will be here.

Refer to the [Getting Started Guide](https://api-platform.com/docs/distribution) for more information.

## Migrations and database
To manage migrations and update the database, follow these steps:

1. Generate a new migration:

    ```bash
    docker compose exec php bin/console doctrine:migrations:diff
    ```

2. Modify the generated migration file:
   Open the generated migration file in `api/migrations` and locate the `id` column for the `Sale` entity. Replace the line:

    ```php
    $this->addSql('CREATE TABLE sale (id INT NOT NULL, ...)');
    ```

   with:

    ```php
    $this->addSql('CREATE TABLE sale (id INT NOT NULL DEFAULT nextval(\'sale_id_seq\'::regclass), ...)');
    ```

3. Apply the migration:

```bash
docker compose exec php bin/console doctrine:migrations:migrate
```

(Optimisation)
Indexation de la Colonne de Date, car toutes les routes font des opérations de filtrage basées sur cette colonne.
````sql
create index date_index on sale (date);
````

## Clear cache

```Shell
sudo docker compose exec php bin/console cache:clear
```

## Run tests

Install fixtures:
```shell
sudo docker compose exec php composer require --dev doctrine/doctrine-fixtures-bundle
```

Create a test database:
```shell
sudo docker compose exec php bin/console doctrine:database:create --env=test
```

Migration:
```shell
sudo docker compose exec php bin/console doctrine:schema:create --env=test
sudo docker compose exec php bin/console doctrine:migrations:migrate --env=test
```

Add fixtures for test:
```shell
sudo docker compose exec php bin/console doctrine:fixtures:load --env=test
```

Run tests:
```Shell
sudo docker compose exec php bin/phpunit tests/Api/SalesTest.php
```

Drop test database:
```shell
sudo docker compose exec php bin/console doctrine:database:drop --force --env=test
```
