import React, { useState } from 'react';
import '../../style/style.css';

const DataForm = ({ onSubmit }) => {
    const [startDate, setStartDate] = useState('');
    const [endDate, setEndDate] = useState('');
    const [granularity, setGranularity] = useState('month');

    const handleSubmit = (event) => {
        event.preventDefault();
        onSubmit({ startDate, endDate, granularity });
    };

    return (
        <form onSubmit={handleSubmit} className="form-container">
            <input
                type="date"
                value={startDate}
                onChange={(e) => setStartDate(e.target.value)}
                required
            />
            <input
                type="date"
                value={endDate}
                onChange={(e) => setEndDate(e.target.value)}
                required
            />
            <select
                value={granularity}
                onChange={(e) => setGranularity(e.target.value)}
            >
                <option value="day">Jour</option>
                <option value="month">Mois</option>
                <option value="year">Année</option>
            </select>
            <button type="submit">Afficher</button>
        </form>
    );
};

export default DataForm;
