<?php

namespace App\Controller;

use App\Dto\BarChart\BarChartInput;
use App\Service\BarChartService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class BarChartController extends AbstractController
{
    private BarChartService $chartService;

    public function __construct(BarChartService $chartService)
    {
        $this->chartService = $chartService;
    }

    #[Route('/sales/bar-chart/{startDate}/{endDate}/{granularity}', name: 'bar-chart', requirements: [
        'startDate' => '\d{4}-\d{2}-\d{2}', // YYYY-MM-DD
        'endDate' => '\d{4}-\d{2}-\d{2}',   //  YYYY-MM-DD
        'granularity' => 'day|month|year',   // day, month, ou year
    ])]
    public function getChartData(string $startDate, string $endDate, string $granularity): JsonResponse
    {
        $input = new BarChartInput();
        $input->start = $startDate;
        $input->end = $endDate;
        $input->granularity = $granularity;

        $chartData = $this->chartService->getBarChartData($input);
        $output = [];
        foreach ($chartData as $data) {
            $output[] = [
                'date' => $data->date,
                'occurrences' => $data->occurrences,
            ];
        }
        return $this->json($output);
    }
}
